/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.ModelTarget;
import io.wispforest.accessories.api.client.Transformation;
import io.wispforest.accessories.api.client.rendering.ModelTransformUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Experimental
public class ClientTransformationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformStack(List<Transformation> transformations, PoseStack poseStack, LivingEntity entity, EntityModel<? extends LivingEntity> model, Runnable renderCall) {
        poseStack.pushPose();
        ClientTransformationUtils.transformStack(transformations, poseStack, entity, model);
        try {
            renderCall.run();
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void transformStack(List<Transformation> transformations, PoseStack poseStack, LivingEntity entity, EntityModel<? extends LivingEntity> model) {
        for (Transformation transformation : transformations) {
            ClientTransformationUtils.transform(transformation, poseStack, entity, model);
        }
    }

    private static void transform(Transformation value, PoseStack poseStack, LivingEntity entity, EntityModel<? extends LivingEntity> model) {
        Transformation transformation = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Transformation.Translation.class, Transformation.RawRotation.class, Transformation.AxisRotation.class, Transformation.Scale.class, Transformation.TransformTo.class, Transformation.Matrix.class}, (Object)transformation, n)) {
            case 0: {
                Transformation.Translation translation = (Transformation.Translation)transformation;
                Vector3f translationVector = translation.translation();
                poseStack.translate(translationVector.x, translationVector.y, translationVector.z);
                break;
            }
            case 1: {
                Transformation.RawRotation rawRotation = (Transformation.RawRotation)transformation;
                poseStack.mulPose(rawRotation.quarternionf());
                break;
            }
            case 2: {
                Transformation.AxisRotation axisRotation = (Transformation.AxisRotation)transformation;
                poseStack.mulPose(axisRotation.axisAngle4f().get(new Quaternionf()));
                break;
            }
            case 3: {
                Transformation.Scale scale = (Transformation.Scale)transformation;
                Vector3f scaleVector = scale.scale();
                poseStack.scale(scaleVector.x, scaleVector.y, scaleVector.z);
                break;
            }
            case 4: {
                Transformation.TransformTo transformTo = (Transformation.TransformTo)transformation;
                ModelTarget modelTarget = transformTo.target();
                if (modelTarget.rawNormal() != null) {
                    Vector3f axisTranslations = modelTarget.rawNormal();
                    ModelTransformUtils.transformToModelPart(poseStack, entity, model, modelTarget.modelPart(), Float.valueOf(axisTranslations.x), Float.valueOf(axisTranslations.y), Float.valueOf(axisTranslations.z));
                    break;
                }
                if (modelTarget.side() != null) {
                    ModelTransformUtils.transformToFace(poseStack, entity, model, modelTarget.modelPart(), modelTarget.side());
                    break;
                }
                ModelTransformUtils.transformToModelPart(poseStack, entity, model, modelTarget.modelPart());
                break;
            }
            case 5: {
                Transformation.Matrix matrix = (Transformation.Matrix)transformation;
                poseStack.mulPose(matrix.matrix4f());
                break;
            }
            default: {
                throw new IllegalStateException("A invalid transform was created meaning such is unable to be encoded!");
            }
        }
    }
}

