/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.blocks.blockentities.HypertubeBlockEntity;
import com.pedrorok.hypertube.client.BezierTextureRenderer;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HypertubeBlockEntityRenderer
implements BlockEntityRenderer<HypertubeBlockEntity> {
    private final BezierTextureRenderer tubeRenderer = BezierTextureRenderer.get();

    public HypertubeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HypertubeBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        IConnection iConnection = blockEntity.getConnectionOne();
        if (iConnection instanceof BezierConnection) {
            BezierConnection bezierConnectionOne = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(blockEntity.getBlockPos(), bezierConnectionOne, poseStack, bufferSource, packedLight, packedOverlay);
        }
        if ((iConnection = blockEntity.getConnectionTwo()) instanceof BezierConnection) {
            BezierConnection bezierConnectionTwo = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(blockEntity.getBlockPos(), bezierConnectionTwo, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    public boolean shouldRenderOffScreen(@NotNull HypertubeBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(@NotNull HypertubeBlockEntity blockEntity, @NotNull Vec3 pos) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull HypertubeBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

