/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.blocks.HyperAcceleratorBlock;
import com.pedrorok.hypertube.blocks.blockentities.HyperAcceleratorBlockEntity;
import com.pedrorok.hypertube.client.BezierTextureRenderer;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.registry.ModPartialModels;
import com.pedrorok.hypertube.utils.RenderUtils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AcceleratorEntityRenderer
extends KineticBlockEntityRenderer<HyperAcceleratorBlockEntity> {
    private final BezierTextureRenderer tubeRenderer = BezierTextureRenderer.get();

    public AcceleratorEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(HyperAcceleratorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        if (!(blockState.getBlock() instanceof HyperAcceleratorBlock)) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)HyperAcceleratorBlock.FACING);
        boolean isTubeOnVertical = facing.getAxis().isVertical();
        be.getTubeAttachments().forEach((direct, attachment) -> {
            SuperByteBuffer smartTubeModel = CachedBuffers.partial((PartialModel)attachment.getPartialModel(blockState, be, (Direction)direct), (BlockState)blockState);
            RenderUtils.rotateToFace(smartTubeModel, facing, direct.getOpposite(), isTubeOnVertical);
            smartTubeModel.light(light);
            smartTubeModel.renderInto(ms, buffer.getBuffer(RenderType.translucent()));
        });
        SuperByteBuffer cogwheelModel = CachedBuffers.partialFacingVertical((PartialModel)ModPartialModels.COGWHEEL_HOLE, (BlockState)blockState, (Direction)facing);
        float angle = AcceleratorEntityRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)facing.getAxis());
        Direction.Axis rotationAxisOf = AcceleratorEntityRenderer.getRotationAxisOf((KineticBlockEntity)be);
        AcceleratorEntityRenderer.kineticRotationTransform((SuperByteBuffer)cogwheelModel, (KineticBlockEntity)be, (Direction.Axis)rotationAxisOf, (float)angle, (int)light);
        cogwheelModel.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        IConnection iConnection = be.getConnectionOne();
        if (iConnection instanceof BezierConnection) {
            BezierConnection bezierConnectionOne = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.getBlockPos(), bezierConnectionOne, ms, buffer, light, overlay);
        }
        if ((iConnection = be.getConnectionTwo()) instanceof BezierConnection) {
            BezierConnection bezierConnectionTwo = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.getBlockPos(), bezierConnectionTwo, ms, buffer, light, overlay);
        }
    }

    public boolean shouldRenderOffScreen(HyperAcceleratorBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(HyperAcceleratorBlockEntity p_173568_, Vec3 p_173569_) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull HyperAcceleratorBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

