/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei;

import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipes;
import umpaz.brewinandchewin.integration.jei.category.CheeseRecipeCategory;
import umpaz.brewinandchewin.integration.jei.category.FermentingRecipeCategory;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = BrewinAndChewin.asResource("jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FermentingRecipeCategory(registry.getJeiHelpers().getGuiHelper(), registry.getJeiHelpers().getPlatformFluidHelper(), registry.getJeiHelpers().getModIdHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CheeseRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        BnCJEIRecipes modRecipes = new BnCJEIRecipes();
        registration.addRecipes(BnCJEIRecipeTypes.FERMENTING, modRecipes.getKegRecipes());
        registration.addRecipes(BnCJEIRecipeTypes.AGING, modRecipes.getCheeseRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BnCItems.KEG), new RecipeType[]{BnCJEIRecipeTypes.FERMENTING});
    }

    public void registerGuiHandlers(final IGuiHandlerRegistration registration) {
        IIngredientHelper test = registration.getJeiHelpers().getIngredientManager().getIngredientHelper((IIngredientType)registration.getJeiHelpers().getPlatformFluidHelper().getFluidIngredientType());
        registration.addRecipeClickArea(KegScreen.class, 80, 25, 23, 17, new RecipeType[]{BnCJEIRecipeTypes.FERMENTING});
        final Rect2i bounds = new Rect2i(107, 18, 26, 30);
        registration.addGuiContainerHandler(KegScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<KegScreen>(this){

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(final KegScreen containerScreen, double mouseX, double mouseY) {
                if (bounds.contains((int)mouseX - containerScreen.getRectangle().left(), (int)mouseY - containerScreen.getRectangle().top())) {
                    return Optional.of(new IClickableIngredient<Object>(){

                        public ITypedIngredient<?> getIngredient() {
                            DataComponentPatch dataComponentPatch;
                            IIngredientManager iIngredientManager = registration.getJeiHelpers().getIngredientManager();
                            IIngredientTypeWithSubtypes iIngredientTypeWithSubtypes = registration.getJeiHelpers().getPlatformFluidHelper().getFluidIngredientType();
                            IPlatformFluidHelper iPlatformFluidHelper = registration.getJeiHelpers().getPlatformFluidHelper();
                            Holder.Reference reference = ((KegMenu)containerScreen.getMenu()).kegTank.getAbstractedFluid().fluid().builtInRegistryHolder();
                            long l = ((KegMenu)containerScreen.getMenu()).kegTank.getAbstractedFluid().amount();
                            DataComponentMap dataComponentMap = ((KegMenu)containerScreen.getMenu()).kegTank.getAbstractedFluid().components();
                            if (dataComponentMap instanceof PatchedDataComponentMap) {
                                PatchedDataComponentMap patched = (PatchedDataComponentMap)dataComponentMap;
                                dataComponentPatch = patched.asPatch();
                            } else {
                                dataComponentPatch = DataComponentPatch.EMPTY;
                            }
                            Optional aef = iIngredientManager.createTypedIngredient((IIngredientType)iIngredientTypeWithSubtypes, iPlatformFluidHelper.create((Holder)reference, l, dataComponentPatch));
                            return aef.orElse(null);
                        }

                        public IIngredientType<Object> getIngredientType() {
                            return registration.getJeiHelpers().getPlatformFluidHelper().getFluidIngredientType();
                        }

                        public ITypedIngredient<Object> getTypedIngredient() {
                            throw new UnsupportedOperationException("getTypedIngredient is not implemented for KegScreen.");
                        }

                        public Rect2i getArea() {
                            return bounds;
                        }
                    });
                }
                return Optional.empty();
            }
        });
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FermentingTransfer.Handler(registration.getTransferHelper(), registration.getJeiHelpers().getStackHelper(), registration.getJeiHelpers().getPlatformFluidHelper()), BnCJEIRecipeTypes.FERMENTING);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

