/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import umpaz.brewinandchewin.common.registry.BnCDamageTypes;
import umpaz.brewinandchewin.data.BnCAdvancements;
import umpaz.brewinandchewin.data.BnCBlockTags;
import umpaz.brewinandchewin.data.BnCBuiltInEntries;
import umpaz.brewinandchewin.data.BnCDamageTypeTags;
import umpaz.brewinandchewin.data.BnCFluidTags;
import umpaz.brewinandchewin.data.BnCItemTags;
import umpaz.brewinandchewin.data.BnCMobEffectTags;
import umpaz.brewinandchewin.data.BnCRecipes;
import umpaz.brewinandchewin.data.loot.BnCBlockLoot;
import umpaz.brewinandchewin.data.recipe.BnCEntityTypeTags;

@EventBusSubscriber(modid="brewinandchewin", bus=EventBusSubscriber.Bus.MOD)
public class BnCDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        BnCBlockTags blockTags = new BnCBlockTags(output, lookupProvider, helper);
        BnCBuiltInEntries builtInEntries = new BnCBuiltInEntries(output, lookupProvider, new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, bootstrap -> bootstrap.register(BnCDamageTypes.CARDIAC_ARREST, (Object)new DamageType("brewinandchewin.cardiacArrest", DamageScaling.NEVER, 0.1f))));
        generator.addProvider(event.includeServer(), (DataProvider)builtInEntries);
        lookupProvider = builtInEntries.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new BnCItemTags(output, lookupProvider, blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BnCFluidTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BnCMobEffectTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BnCEntityTypeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BnCDamageTypeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BnCRecipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BnCBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, lookupProvider, helper, List.of(new BnCAdvancements())));
    }
}

