/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.item;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BoozeItem
extends Item {
    private final Supplier<Fluid> fluid;
    public static final Set<Supplier<Holder<MobEffect>>> RED_EFFECTS = Set.of(() -> BnCEffects.TIPSY, () -> MobEffects.BAD_OMEN);

    public BoozeItem(Supplier<Fluid> fluid, Item.Properties properties) {
        super(properties);
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (BrewinAndChewin.getHelper().isEdible(heldStack, (LivingEntity)player)) {
            if (player.canEat(BrewinAndChewin.getHelper().getFoodProperties(heldStack, (LivingEntity)player).canAlwaysEat())) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            Optional<FoodProperties.PossibleEffect> tipsy = BrewinAndChewin.getHelper().getFoodProperties(stack, consumer).effects().stream().filter(pair -> pair.effect().getEffect() == BnCEffects.TIPSY).findFirst();
            this.affectConsumer(consumer, tipsy.map(pair -> pair.effect().getDuration()).orElse(0), tipsy.map(pair -> pair.effect().getAmplifier()).orElse(-1));
        }
        ItemStack containerStack = BrewinAndChewin.getHelper().getCraftingRemainingItem(stack);
        if (BrewinAndChewin.getHelper().isEdible(stack, consumer)) {
            super.finishUsingItem(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        if (stack.isEmpty()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).getAbilities().instabuild && !player.getInventory().add(containerStack)) {
                player.drop(containerStack, false);
            }
        }
        return stack;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public void affectConsumer(LivingEntity consumer, int duration, int potency) {
        if (consumer.hasEffect(BnCEffects.TIPSY)) {
            MobEffectInstance effect = consumer.getEffect(BnCEffects.TIPSY);
            consumer.addEffect(new MobEffectInstance(BnCEffects.TIPSY, effect.getDuration() == -1 ? -1 : effect.getDuration() + duration, Math.min(effect.getAmplifier() + potency + 1, 9), effect.isAmbient(), effect.isVisible(), effect.showIcon()));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (!BrewinAndChewin.getHelper().hasFoodEffectTooltip()) {
            return;
        }
        TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
        for (int i = 0; i < tooltip.size(); ++i) {
            Component component = tooltip.get(i);
            if (!RED_EFFECTS.stream().anyMatch(holder -> component.contains((Component)Component.translatable((String)((MobEffect)((Holder)holder.get()).value()).getDescriptionId())))) continue;
            tooltip.set(i, (Component)component.copy().withStyle(ChatFormatting.RED));
        }
    }
}

