/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import umpaz.brewinandchewin.common.utility.AbstractedFluidIngredient;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCStreamCodecs;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public record FluidIngredientWithAmount(AbstractedFluidIngredient ingredient, long amount, Optional<FluidUnit> unit) {
    public static final Codec<FluidIngredientWithAmount> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)AbstractedFluidIngredient.CODEC.fieldOf("ingredient").forGetter(FluidIngredientWithAmount::ingredient), (App)Codec.LONG.validate(l -> {
        if (l < 1L) {
            return DataResult.error(() -> "Fluid Ingredient amount must be at least 1.");
        }
        return DataResult.success((Object)l);
    }).optionalFieldOf("amount").forGetter(fluidIngredientWithAmount -> Optional.of(fluidIngredientWithAmount.amount())), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(FluidIngredientWithAmount::unit)).apply((Applicative)inst, (t1, t2, t3) -> new FluidIngredientWithAmount((AbstractedFluidIngredient)t1, t2.orElseGet(() -> t1.displayStacks().getFirst().amount()), (Optional<FluidUnit>)t3)));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredientWithAmount> STREAM_CODEC = StreamCodec.composite(AbstractedFluidIngredient.STREAM_CODEC, FluidIngredientWithAmount::ingredient, BnCStreamCodecs.LONG, FluidIngredientWithAmount::amount, (StreamCodec)ByteBufCodecs.optional(FluidUnit.STREAM_CODEC), FluidIngredientWithAmount::unit, FluidIngredientWithAmount::new);

    public FluidIngredientWithAmount {
        if (ingredient.matches(AbstractedFluidStack.EMPTY)) {
            throw new IllegalArgumentException("Fluid Ingredient must not accept empty.");
        }
        if (amount <= 0L) {
            throw new IllegalArgumentException("Fluid Ingredient amount must be higher than 0.");
        }
    }

    public FluidUnit getUnit() {
        return this.unit().orElse(FluidUnit.getLoaderUnit());
    }

    public long loaderAmount() {
        FluidUnit unit = this.unit().orElse(FluidUnit.getLoaderUnit());
        return unit.convertToLoader(this.amount);
    }
}

