/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.renderer.texture.modifier;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;

public class PotionTintTextureModifier
implements TextureModifier {
    public static final ResourceLocation ID = BrewinAndChewin.asResource("potion_tint");
    public static final MapCodec<PotionTintTextureModifier> CODEC = MapCodec.unit(PotionTintTextureModifier::new);

    @Override
    public int color(BlockAndTintGetter level, BlockState state, BlockPos pos, ItemStack stack, int previous) {
        int color = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
        int red = FastColor.ARGB32.red((int)color);
        int green = FastColor.ARGB32.green((int)color);
        int blue = FastColor.ARGB32.blue((int)color);
        return FastColor.ARGB32.color((int)255, (int)red, (int)green, (int)blue);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends TextureModifier> codec() {
        return CODEC;
    }
}

