/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.vinurl.client.SoundManager;
import com.vinurl.client.VinURLClient;
import com.vinurl.exe.Executable;
import com.vinurl.net.ServerEvent;
import com.vinurl.util.Constants;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SlimSliderComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.util.NinePatchTexture;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class URLScreen
extends BaseUIModelScreen<StackLayout> {
    private String url;
    private boolean loop;
    private boolean lock;
    private boolean sliderDragged;
    private boolean simulate;
    private int duration;
    private final ButtonComponent.Renderer SIMULATE_BUTTON_TEXTURE = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        class_2960 texture = !this.simulate ? (button.field_22763 && button.method_49606() ? class_2960.method_60655((String)"vinurl", (String)"simulate_button_hovered") : class_2960.method_60655((String)"vinurl", (String)"simulate_button")) : class_2960.method_60655((String)"vinurl", (String)"simulate_button_disabled");
        NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.method_25368(), (int)button.method_25364());
    };
    private final ButtonComponent.Renderer LOOP_BUTTON_TEXTURE = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        class_2960 texture = this.loop ? class_2960.method_60655((String)"vinurl", (String)"loop_button") : class_2960.method_60655((String)"vinurl", (String)"loop_button_disabled");
        NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.method_25368(), (int)button.method_25364());
    };
    private final ButtonComponent.Renderer LOCK_BUTTON_TEXTURE = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        class_2960 texture = this.lock ? class_2960.method_60655((String)"vinurl", (String)"lock_button") : class_2960.method_60655((String)"vinurl", (String)"lock_button_disabled");
        NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.method_25368(), (int)button.method_25364());
    };

    public URLScreen(String defaultURL, int defaultDuration, boolean defaultLoop) {
        super(StackLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_60655((String)"vinurl", (String)"disc_url_screen")));
        this.url = defaultURL;
        this.loop = defaultLoop;
        this.duration = defaultDuration;
    }

    protected void build(StackLayout stackLayout) {
        LabelComponent placeholderLabel = (LabelComponent)stackLayout.childById(LabelComponent.class, "placeholder_label");
        TextBoxComponent urlTextbox = (TextBoxComponent)stackLayout.childById(TextBoxComponent.class, "url_textbox");
        SlimSliderComponent durationSlider = (SlimSliderComponent)stackLayout.childById(SlimSliderComponent.class, "duration_slider");
        ButtonComponent loopButton = (ButtonComponent)stackLayout.childById(ButtonComponent.class, "loop_button");
        ButtonComponent lockButton = (ButtonComponent)stackLayout.childById(ButtonComponent.class, "lock_button");
        ButtonComponent simulateButton = (ButtonComponent)stackLayout.childById(ButtonComponent.class, "simulate_button");
        TextureComponent textFieldTexture = (TextureComponent)stackLayout.childById(TextureComponent.class, "text_field_disabled");
        durationSlider.value((double)this.duration);
        durationSlider.tooltipSupplier(slider -> class_2561.method_43470((String)String.format("%02d:%02d", this.duration / 60, this.duration % 60)));
        durationSlider.mouseDrag().subscribe((mouseX, mouseY, deltaX, deltaY, button) -> {
            this.sliderDragged = true;
            simulateButton.field_22763 = false;
            loopButton.field_22763 = false;
            lockButton.field_22763 = false;
            return true;
        });
        durationSlider.mouseUp().subscribe((mouseX, mouseY, button) -> {
            this.sliderDragged = false;
            simulateButton.field_22763 = true;
            loopButton.field_22763 = true;
            lockButton.field_22763 = true;
            return true;
        });
        durationSlider.onChanged().subscribe(newValue -> {
            this.duration = (int)newValue;
        });
        durationSlider.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            durationSlider.value(Math.clamp(durationSlider.value() + amount, durationSlider.min(), durationSlider.max()));
            return true;
        });
        loopButton.renderer(this.LOOP_BUTTON_TEXTURE);
        loopButton.onPress(button -> {
            this.loop = !this.loop;
        });
        lockButton.renderer(this.LOCK_BUTTON_TEXTURE);
        lockButton.onPress(button -> {
            this.lock = !this.lock;
        });
        simulateButton.renderer(this.SIMULATE_BUTTON_TEXTURE);
        simulateButton.onPress(button -> {
            if (this.simulate) {
                return;
            }
            this.simulate = true;
            button.tooltip((class_2561)class_2561.method_43470((String)"Calculating..."));
            Executable.YT_DLP.executeCommand(SoundManager.getFileName(this.url) + "/duration", this.url, "--print", "DURATION: %(duration)d", "--no-playlist").subscribe("duration").onOutput(line -> {
                String type = line.substring(0, line.indexOf(58) + 1);
                String message = line.substring(type.length()).trim();
                switch (type) {
                    case "DURATION:": {
                        durationSlider.value((double)Integer.parseInt(message));
                        break;
                    }
                    case "WARNING:": {
                        Constants.LOGGER.warn(message);
                        break;
                    }
                    case "ERROR:": {
                        Constants.LOGGER.error(message);
                        break;
                    }
                    default: {
                        Constants.LOGGER.info(line);
                    }
                }
            }).onError(error -> {
                button.tooltip((class_2561)class_2561.method_43470((String)"Automatic Duration"));
                this.simulate = false;
            }).onComplete(() -> {
                button.tooltip((class_2561)class_2561.method_43470((String)"Automatic Duration"));
                this.simulate = false;
            }).start();
        });
        urlTextbox.onChanged().subscribe(text -> {
            this.url = text;
            placeholderLabel.text((class_2561)class_2561.method_43470((String)(this.url.isEmpty() ? "URL" : "")));
        });
        urlTextbox.text(this.url);
        urlTextbox.focusLost().subscribe(() -> textFieldTexture.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)110, (int)16)));
        urlTextbox.focusGained().subscribe(source -> textFieldTexture.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)0, (int)0)));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257) {
            Constants.NETWORK_CHANNEL.clientHandle().send((Record)new ServerEvent.SetURLRecord(this.url, this.duration, this.loop, this.lock));
            VinURLClient.CLIENT.method_1507(null);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.sliderDragged) {
            context.method_51438(VinURLClient.CLIENT.field_1772, (class_2561)class_2561.method_43470((String)String.format("%02d:%02d", this.duration / 60, this.duration % 60)), mouseX, mouseY);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

