/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.tom.createores.Registration;
import com.tom.createores.jei.ItemIcon;
import com.tom.createores.jei.JEIRecipes;
import com.tom.createores.jei.Vein;
import com.tom.createores.jei.VeinIngredient;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.BiomeTooltip;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class VeinCategory
implements IRecipeCategory<RecipeHolder<VeinRecipe>> {
    protected IDrawable icon = new ItemIcon(() -> new ItemStack((ItemLike)Registration.NORMAL_DRILL_ITEM.get()));
    protected IDrawable biomeWIcon = new ItemIcon(() -> new ItemStack((ItemLike)Items.OAK_SAPLING));
    protected IDrawable biomeBIcon = new DoubleItemIcon(() -> new ItemStack((ItemLike)Items.OAK_SAPLING), () -> new ItemStack((ItemLike)Items.BARRIER));

    public int getWidth() {
        return 177;
    }

    public int getHeight() {
        return 100;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<VeinRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 25).addIngredient(VeinIngredient.VEIN, (Object)new Vein(recipe));
    }

    public void draw(RecipeHolder<VeinRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.biomeWIcon.draw(stack, 100, 5);
        this.biomeBIcon.draw(stack, 100, 25);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<VeinRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 100.0 && mouseX < 118.0) {
            if (mouseY > 5.0 && mouseY < 23.0) {
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.coe.biome.whitelist"));
                BiomeTooltip.listBiomes(((VeinRecipe)recipe.value()).biomeWhitelist, tooltip);
            } else if (mouseY > 25.0 && mouseY < 43.0) {
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.coe.biome.blacklist"));
                BiomeTooltip.listBiomes(((VeinRecipe)recipe.value()).biomeBlacklist, tooltip);
            } else {
                BiomeTooltip.resetPage();
            }
        }
    }

    public RecipeType<RecipeHolder<VeinRecipe>> getRecipeType() {
        return JEIRecipes.VEINS;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.coe.recipe.veins");
    }
}

