/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.Registration;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.block.entity.MultiblockCapHandler;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.TooltipUtil;
import java.util.Comparator;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public abstract class ExcavatingBlockEntity<R extends ExcavatingRecipe>
extends SmartBlockEntity
implements MultiblockCapHandler,
IDrill {
    protected int progress;
    protected MultiblockCapHandler.Kinetic kinetic;
    protected ResourceLocation veinClient;
    protected ResourceLocation recipeClient;
    protected long resourceRemClient;
    protected boolean hasRotation;
    protected ItemStack drillStack;
    protected RecipeHolder<R> current;
    protected RecipeHolder<VeinRecipe> vein;
    protected OreData data;
    protected ExcavatorState state = ExcavatorState.NO_VEIN;
    protected boolean completedOneCycle;

    protected ExcavatingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.drillStack = ItemStack.EMPTY;
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VeinRecipe veinR = this.veinClient != null ? (VeinRecipe)this.level.getRecipeManager().byKey(this.veinClient).filter(e -> e.value() instanceof VeinRecipe).map(r -> (VeinRecipe)r.value()).orElse(null) : null;
        Component vein = veinR != null ? veinR.getName() : Component.translatable((String)"chat.coe.veinFinder.nothing");
        ExcavatingRecipe rec = this.recipeClient != null ? (ExcavatingRecipe)this.level.getRecipeManager().byKey(this.recipeClient).filter(r -> r.value().getType() == this.getRecipeType()).map(r -> (ExcavatingRecipe)r.value()).orElse(null) : null;
        TooltipUtil.forGoggles(tooltip, Component.translatable((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein}));
        if (!this.hasRotation) {
            TooltipUtil.forGoggles(tooltip, CreateLang.translateDirect((String)"tooltip.speedRequirement", (Object[])new Object[0]).withStyle(ChatFormatting.GOLD));
            MutableComponent hint = CreateLang.translateDirect((String)"gui.contraptions.not_fast_enough", (Object[])new Object[]{I18n.get((String)this.getBlockState().getBlock().getDescriptionId(), (Object[])new Object[0])});
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                TooltipUtil.forGoggles(tooltip, ((Component)cutString.get(i)).copy());
            }
        }
        if (this.drillStack.isEmpty()) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.noDrill"));
        } else {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.installed", (Object[])new Object[]{this.drillStack.getHoverName()}));
        }
        if (!this.level.getBlockState(this.getBelow()).isCollisionShapeFullBlock((BlockGetter)this.level, this.getBelow())) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.noGround"));
        }
        if (rec != null) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.progress").append(": [").append(ClientUtil.makeProgressBar((float)this.progress / (float)rec.getTicks())).append("]"));
            if (this.resourceRemClient != 0L) {
                TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)}));
            }
            if (!rec.getDrill().test(this.drillStack)) {
                TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.badDrill"));
            }
            this.addToGoggleTooltip(tooltip, rec);
        }
        if (this.state != ExcavatorState.NO_ERROR) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)("info.coe.drill.err_" + this.state.name().toLowerCase())));
        }
        return true;
    }

    public void addToGoggleTooltip(List<Component> tooltip, R recipe) {
    }

    public void updateRecipe() {
        this.vein = null;
        this.current = null;
        ChunkPos p = new ChunkPos(this.worldPosition);
        this.data = OreDataAttachment.getData(this.level.getChunk(p.x, p.z));
        RecipeManager m = this.level.getRecipeManager();
        if (this.data != null) {
            this.vein = this.data.getRecipe(m);
            if (this.vein != null) {
                List<RecipeHolder> rec = m.getAllRecipesFor(this.getRecipeType()).stream().filter(r -> ((ExcavatingRecipe)r.value()).veinId.equals((Object)this.vein.id())).sorted(Comparator.comparingInt(r -> ((ExcavatingRecipe)r.value()).priority)).toList();
                if (rec.size() == 1) {
                    this.current = rec.get(0);
                } else if (rec.size() > 1) {
                    for (RecipeHolder r2 : rec) {
                        if (!this.validateRecipe((ExcavatingRecipe)r2.value())) continue;
                        this.current = r2;
                    }
                    if (this.current == null) {
                        this.current = rec.get(0);
                    }
                }
            }
        }
    }

    protected boolean validateRecipe(R recipe) {
        return ((ExcavatingRecipe)recipe).getDrill().test(this.drillStack);
    }

    protected abstract RecipeType<R> getRecipeType();

    protected abstract boolean canExtract();

    protected abstract void onFinished();

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.current != null && this.state == ExcavatorState.NO_ERROR) {
                if (this.kinetic != null) {
                    this.kinetic.setStress(((ExcavatingRecipe)this.current.value()).getStress());
                }
                if (this.canExtract() && this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() && ((ExcavatingRecipe)this.current.value()).getDrill().test(this.drillStack) && this.level.getBlockState(this.getBelow()).isCollisionShapeFullBlock((BlockGetter)this.level, this.getBelow())) {
                    float prg = this.kinetic.getRotationSpeed() / IRotate.SpeedLevel.MEDIUM.getSpeedValue();
                    this.progress = (int)((float)this.progress + prg);
                    if (this.progress >= ((ExcavatingRecipe)this.current.value()).getTicks()) {
                        this.updateState();
                        if (this.state == ExcavatorState.NO_ERROR) {
                            this.onFinished();
                            this.data.extract(1);
                            this.completedOneCycle = true;
                            this.setChanged();
                        }
                        this.progress = 0;
                    }
                } else if (!((ExcavatingRecipe)this.current.value()).getDrill().test(this.drillStack)) {
                    RecipeHolder<R> old = this.current;
                    this.updateRecipe();
                    if (old != this.current) {
                        this.progress = 0;
                    }
                }
            } else if (this.progress > 10) {
                this.progress = 0;
                this.updateState();
            } else {
                ++this.progress;
            }
        }
    }

    private void updateState() {
        this.updateRecipe();
        this.state = this.vein == null ? ExcavatorState.NO_VEIN : (!this.data.canExtract(this.level, this.worldPosition) ? ExcavatorState.TOO_MANY_EXCAVATORS : (this.data.getResourcesRemaining((VeinRecipe)this.vein.value()) == -1L ? ExcavatorState.VEIN_EMPTY : (this.current == null ? ExcavatorState.NO_RECIPE : ExcavatorState.NO_ERROR)));
        this.notifyUpdate();
    }

    public void lazyTick() {
        this.notifyUpdate();
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.progress = tag.getInt("progress");
        this.drillStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("drill"));
        this.completedOneCycle = tag.getBoolean("finishedOnce");
        if (clientPacket) {
            this.state = ExcavatorState.VALUES[tag.getByte("state")];
            if (tag.contains("veinId")) {
                this.veinClient = ResourceLocation.tryParse((String)tag.getString("veinId"));
                this.resourceRemClient = tag.getLong("resRem");
            } else {
                this.veinClient = null;
            }
            this.recipeClient = tag.contains("currentRecipeId") ? ResourceLocation.tryParse((String)tag.getString("currentRecipeId")) : null;
            this.hasRotation = tag.getBoolean("hasRot");
        }
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("progress", this.progress);
        if (!this.drillStack.isEmpty()) {
            tag.put("drill", this.drillStack.save(registries));
        }
        tag.putBoolean("finishedOnce", this.completedOneCycle);
        if (clientPacket) {
            tag.putByte("state", (byte)this.state.ordinal());
            if (this.vein != null) {
                tag.putString("veinId", this.vein.id().toString());
                tag.putLong("resRem", this.data.getResourcesRemaining((VeinRecipe)this.vein.value()));
            }
            if (this.current != null) {
                tag.putString("currentRecipeId", this.current.id().toString());
            }
            tag.putBoolean("hasRot", this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue());
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.level.isClientSide) {
            if (this.progress > 0 && this.current == null) {
                this.updateRecipe();
            }
            if (this.current == null) {
                this.progress = 0;
            }
        }
    }

    @Override
    public ItemStack getDrill() {
        return this.drillStack;
    }

    @Override
    public BlockPos getBelow() {
        return this.worldPosition.below(2);
    }

    @Override
    public void addKinetic(MultiblockCapHandler.Kinetic k) {
        this.kinetic = k;
    }

    @Override
    public void dropInv() {
        this.dropItemStack(this.drillStack);
    }

    public ItemInteractionResult onClick(Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        if (item.getItem() == Registration.VEIN_ATLAS_ITEM.get()) {
            if (!this.level.isClientSide) {
                if (this.completedOneCycle) {
                    ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).addVein(player, item, this.vein, new DimChunkPos(this.level, this.worldPosition), this.data.getRandomMul());
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.notDone"), true);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (item.is(CreateOreExcavation.DRILL_TAG) && this.drillStack.isEmpty()) {
            if (!this.level.isClientSide) {
                this.drillStack = item.split(1);
            }
            this.notifyUpdate();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult onClick(Player player) {
        if (!this.drillStack.isEmpty()) {
            if (!this.level.isClientSide) {
                if (player.addItem(this.drillStack)) {
                    this.drillStack = ItemStack.EMPTY;
                    this.notifyUpdate();
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void dropItemStack(ItemStack stackInSlot) {
        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stackInSlot);
    }

    protected AABB createRenderBoundingBox() {
        return AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition.offset(-1, -1, -1), (BlockPos)this.worldPosition.offset(1, 0, 1));
    }

    @Override
    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public boolean shouldRenderRubble() {
        return this.completedOneCycle || this.recipeClient != null && this.progress > 0;
    }

    @Override
    public float getYOffset() {
        return 0.8f;
    }

    @Override
    public float getDrillOffset() {
        return this.isActive() ? 0.2f : 0.0f;
    }

    private boolean isActive() {
        return this.recipeClient != null && this.hasRotation;
    }

    @Override
    public float getRotation() {
        if (this.isActive()) {
            long ticks = this.getLevel().getGameTime();
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public float getPrevRotation() {
        if (this.isActive()) {
            long ticks = this.getLevel().getGameTime() - 1L;
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderShaft() {
        return true;
    }

    public static enum ExcavatorState {
        NO_ERROR,
        NO_VEIN,
        VEIN_EMPTY,
        TOO_MANY_EXCAVATORS,
        NO_RECIPE;

        public static final ExcavatorState[] VALUES;

        static {
            VALUES = ExcavatorState.values();
        }
    }
}

