/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.interval_tree;

import java.util.Comparator;

public abstract class Interval<T extends Comparable<? super T>> {
    private T start;
    private T end;
    private boolean isStartInclusive;
    private boolean isEndInclusive;
    public static final Comparator<Interval> sweepLeftToRight = (a, b) -> {
        int compare = a.compareStarts((Interval)b);
        if (compare != 0) {
            return compare;
        }
        compare = a.compareEnds((Interval)b);
        if (compare != 0) {
            return compare;
        }
        return a.compareSpecialization((Interval)b);
    };
    public static final Comparator<Interval> sweepRightToLeft = (a, b) -> {
        int compare = b.compareEnds((Interval)a);
        if (compare != 0) {
            return compare;
        }
        compare = b.compareStarts((Interval)a);
        if (compare != 0) {
            return compare;
        }
        return a.compareSpecialization((Interval)b);
    };

    public Interval() {
        this.isStartInclusive = true;
        this.isEndInclusive = true;
    }

    public Interval(T start, T end, Bounded type) {
        this.start = start;
        this.end = end;
        if (type == null) {
            type = Bounded.CLOSED;
        }
        switch (type.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.isStartInclusive = true;
                this.isEndInclusive = true;
                break;
            }
            case 2: {
                this.isEndInclusive = true;
                break;
            }
            default: {
                this.isStartInclusive = true;
            }
        }
    }

    public Interval(T value, Unbounded type) {
        if (type == null) {
            type = Unbounded.CLOSED_RIGHT;
        }
        switch (type.ordinal()) {
            case 0: {
                this.start = value;
                this.isStartInclusive = false;
                this.isEndInclusive = true;
                break;
            }
            case 1: {
                this.start = value;
                this.isStartInclusive = true;
                this.isEndInclusive = true;
                break;
            }
            case 2: {
                this.end = value;
                this.isStartInclusive = true;
                this.isEndInclusive = false;
                break;
            }
            default: {
                this.end = value;
                this.isStartInclusive = true;
                this.isEndInclusive = true;
            }
        }
    }

    public boolean isEmpty() {
        if (this.start == null || this.end == null) {
            return false;
        }
        int compare = this.start.compareTo(this.end);
        if (compare > 0) {
            return true;
        }
        return compare == 0 && (!this.isEndInclusive || !this.isStartInclusive);
    }

    protected abstract Interval<T> create();

    public abstract T getMidpoint();

    protected Interval<T> create(T start, boolean isStartInclusive, T end, boolean isEndInclusive) {
        Interval<T> interval = this.create();
        interval.start = start;
        interval.isStartInclusive = isStartInclusive;
        interval.end = end;
        interval.isEndInclusive = isEndInclusive;
        return interval;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean isStartInclusive() {
        return this.isStartInclusive;
    }

    public boolean isEndInclusive() {
        return this.isEndInclusive;
    }

    public boolean contains(T query) {
        int endCompare;
        if (this.isEmpty() || query == null) {
            return false;
        }
        int startCompare = this.start == null ? 1 : query.compareTo(this.start);
        int n = endCompare = this.end == null ? -1 : query.compareTo(this.end);
        if (startCompare > 0 && endCompare < 0) {
            return true;
        }
        return startCompare == 0 && this.isStartInclusive || endCompare == 0 && this.isEndInclusive;
    }

    public Interval<T> getIntersection(Interval<T> other) {
        boolean isNewEndInclusive;
        T newEnd;
        boolean isNewStartInclusive;
        T newStart;
        if (other == null || this.isEmpty() || other.isEmpty()) {
            return null;
        }
        if (other.start == null && this.start != null || this.start != null && this.start.compareTo(other.start) > 0) {
            return other.getIntersection(this);
        }
        if (!(this.end == null || other.start == null || this.end.compareTo(other.start) >= 0 && (this.end.compareTo(other.start) != 0 || this.isEndInclusive && other.isStartInclusive))) {
            return null;
        }
        if (other.start == null) {
            newStart = null;
            isNewStartInclusive = true;
        } else {
            newStart = other.start;
            isNewStartInclusive = this.start != null && other.start.compareTo(this.start) == 0 ? other.isStartInclusive && this.isStartInclusive : other.isStartInclusive;
        }
        if (this.end == null) {
            newEnd = other.end;
            isNewEndInclusive = other.isEndInclusive;
        } else if (other.end == null) {
            newEnd = this.end;
            isNewEndInclusive = this.isEndInclusive;
        } else {
            int compare = this.end.compareTo(other.end);
            if (compare == 0) {
                newEnd = this.end;
                isNewEndInclusive = this.isEndInclusive && other.isEndInclusive;
            } else if (compare < 0) {
                newEnd = this.end;
                isNewEndInclusive = this.isEndInclusive;
            } else {
                newEnd = other.end;
                isNewEndInclusive = other.isEndInclusive;
            }
        }
        Interval<Object> intersection = this.create(newStart, isNewStartInclusive, newEnd, isNewEndInclusive);
        return intersection.isEmpty() ? null : intersection;
    }

    public boolean intersects(Interval<T> query) {
        if (query == null) {
            return false;
        }
        Interval<T> intersection = this.getIntersection(query);
        return intersection != null;
    }

    public boolean isRightOf(T point, boolean inclusive) {
        if (point == null || this.start == null) {
            return false;
        }
        int compare = point.compareTo(this.start);
        if (compare != 0) {
            return compare < 0;
        }
        return !this.isStartInclusive() || !inclusive;
    }

    public boolean isRightOf(T point) {
        return this.isRightOf(point, true);
    }

    public boolean isRightOf(Interval<T> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return this.isRightOf(other.end, other.isEndInclusive());
    }

    public boolean isLeftOf(T point, boolean inclusive) {
        if (point == null || this.end == null) {
            return false;
        }
        int compare = point.compareTo(this.end);
        if (compare != 0) {
            return compare > 0;
        }
        return !this.isEndInclusive() || !inclusive;
    }

    public boolean isLeftOf(T point) {
        return this.isLeftOf(point, true);
    }

    public boolean isLeftOf(Interval<T> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return this.isLeftOf(other.start, other.isStartInclusive());
    }

    private int compareStarts(Interval<T> other) {
        if (this.start == null && other.start == null) {
            return 0;
        }
        if (this.start == null) {
            return -1;
        }
        if (other.start == null) {
            return 1;
        }
        int compare = this.start.compareTo(other.start);
        if (compare != 0) {
            return compare;
        }
        if (this.isStartInclusive ^ other.isStartInclusive) {
            return this.isStartInclusive ? -1 : 1;
        }
        return 0;
    }

    private int compareEnds(Interval<T> other) {
        if (this.end == null && other.end == null) {
            return 0;
        }
        if (this.end == null) {
            return 1;
        }
        if (other.end == null) {
            return -1;
        }
        int compare = this.end.compareTo(other.end);
        if (compare != 0) {
            return compare;
        }
        if (this.isEndInclusive ^ other.isEndInclusive) {
            return this.isEndInclusive ? 1 : -1;
        }
        return 0;
    }

    protected int compareSpecialization(Interval<T> other) {
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.start == null ? 0 : this.start.hashCode();
        result = prime * result + (this.end == null ? 0 : this.end.hashCode());
        result = prime * result + (this.isStartInclusive ? 1 : 0);
        result = prime * result + (this.isEndInclusive ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.start == null ^ other.start == null) {
            return false;
        }
        if (this.end == null ^ other.end == null) {
            return false;
        }
        if (this.isEndInclusive ^ other.isEndInclusive) {
            return false;
        }
        if (this.isStartInclusive ^ other.isStartInclusive) {
            return false;
        }
        if (this.start != null && !this.start.equals(other.start)) {
            return false;
        }
        return this.end == null || this.end.equals(other.end);
    }

    public static enum Bounded {
        OPEN,
        CLOSED,
        CLOSED_RIGHT,
        CLOSED_LEFT;

    }

    public static enum Unbounded {
        OPEN_LEFT,
        CLOSED_LEFT,
        OPEN_RIGHT,
        CLOSED_RIGHT;

    }
}

