/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.ChunkCompoundTagParser;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.RegionFileStorageExternalCache;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.GlobalWorldGenParams;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2867;
import net.minecraft.class_3218;
import net.minecraft.class_4698;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_7924;

public class ChunkFileReader
implements AutoCloseable {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD World Gen").fileLevelConfig(Config.Common.Logging.logWorldGenEventToFile).build();
    public static final DhLogger CHUNK_LOAD_LOGGER = new DhLoggerBuilder().name("LOD Chunk Loading").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final IModChecker MOD_CHECKER = SingletonInjector.INSTANCE.get(IModChecker.class);
    public final GlobalWorldGenParams params;
    private boolean pullExistingChunkUsingMcAsyncMethod = false;
    private final AtomicReference<RegionFileStorageExternalCache> regionFileStorageCacheRef = new AtomicReference();

    public RegionFileStorageExternalCache getOrCreateRegionFileCache(class_2867 storage) {
        RegionFileStorageExternalCache cache = this.regionFileStorageCacheRef.get();
        if (cache == null && !this.regionFileStorageCacheRef.compareAndSet(null, cache = new RegionFileStorageExternalCache(storage))) {
            cache = this.regionFileStorageCacheRef.get();
        }
        return cache;
    }

    public ChunkFileReader(GlobalWorldGenParams params) {
        this.params = params;
        if (MOD_CHECKER.isModLoaded("c2me")) {
            LOGGER.info("C2ME detected: DH's pre-existing chunk accessing will use methods handled by C2ME.", new Object[0]);
            this.pullExistingChunkUsingMcAsyncMethod = true;
        }
    }

    public CompletableFuture<ChunkWrapper> createEmptyOrPreExistingChunkWrapperAsync(int chunkX, int chunkZ, Map<DhChunkPos, ChunkLightStorage> chunkSkyLightingByDhPos, Map<DhChunkPos, ChunkLightStorage> chunkBlockLightingByDhPos, Map<DhChunkPos, ChunkWrapper> generatedChunkWrapperByDhPos) {
        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
        DhChunkPos dhChunkPos = new DhChunkPos(chunkX, chunkZ);
        if (generatedChunkWrapperByDhPos.containsKey(dhChunkPos)) {
            return CompletableFuture.completedFuture(generatedChunkWrapperByDhPos.get(dhChunkPos));
        }
        return ((CompletableFuture)((CompletableFuture)this.getChunkNbtDataAsync(chunkPos).thenApply(chunkData -> {
            ChunkWrapper newChunkWrapper = this.loadOrMakeChunkWrapper(chunkPos, (class_2487)chunkData);
            ChunkCompoundTagParser.CombinedChunkLightStorage combinedLights = ChunkCompoundTagParser.readLight(newChunkWrapper.getChunk(), chunkData);
            if (combinedLights != null) {
                chunkSkyLightingByDhPos.put(dhChunkPos, combinedLights.skyLightStorage);
                chunkBlockLightingByDhPos.put(dhChunkPos, combinedLights.blockLightStorage);
            }
            return newChunkWrapper;
        })).handle((newChunkWrapper, throwable) -> {
            if (newChunkWrapper != null) {
                return newChunkWrapper;
            }
            return this.CreateProtoChunkWrapper(this.params.mcServerLevel, chunkPos);
        })).thenApply(newChunkWrapper -> {
            generatedChunkWrapperByDhPos.put(dhChunkPos, (ChunkWrapper)newChunkWrapper);
            return newChunkWrapper;
        });
    }

    private CompletableFuture<class_2487> getChunkNbtDataAsync(class_1923 chunkPos) {
        class_3218 level = this.params.mcServerLevel;
        try {
            class_4698 ioWorker = level.method_14178().field_17254.field_21494;
            if (!this.pullExistingChunkUsingMcAsyncMethod && ioWorker.field_21499 != null) {
                try {
                    class_2867 storage = this.params.mcServerLevel.method_14178().field_17254.field_21494.field_21499;
                    RegionFileStorageExternalCache cache = this.getOrCreateRegionFileCache(storage);
                    return CompletableFuture.completedFuture(cache.read(chunkPos));
                }
                catch (NullPointerException e) {
                    LOGGER.error("Unexpected issue pulling pre-existing chunk [" + String.valueOf(chunkPos) + "], falling back to async chunk pulling. This may cause server-tick lag.", e);
                    this.pullExistingChunkUsingMcAsyncMethod = true;
                    return this.getChunkNbtDataAsync(chunkPos);
                }
            }
            if (!this.pullExistingChunkUsingMcAsyncMethod) {
                LOGGER.info("Unable to pull pre-existing chunk using synchronous method. Falling back to async method. this may cause server-tick lag.", new Object[0]);
                this.pullExistingChunkUsingMcAsyncMethod = true;
            }
            return ((CompletableFuture)ioWorker.method_31738(chunkPos).thenApply(optional -> optional.orElse(null))).exceptionally(throwable -> {
                Throwable actualThrowable = throwable;
                while (actualThrowable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)actualThrowable;
                    actualThrowable = completionException.getCause();
                }
                boolean isShutdownException = ExceptionUtil.isShutdownException(actualThrowable);
                if (!isShutdownException) {
                    CHUNK_LOAD_LOGGER.warn("DistantHorizons: Couldn't load or make chunk [" + String.valueOf(chunkPos) + "], error: [" + actualThrowable.getMessage() + "].", actualThrowable);
                }
                return null;
            });
        }
        catch (ClosedByInterruptException ignore) {
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            CHUNK_LOAD_LOGGER.warn("Couldn't load or make chunk [" + String.valueOf(chunkPos) + "]. Error: [" + e.getMessage() + "].", e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private ChunkWrapper loadOrMakeChunkWrapper(class_1923 chunkPos, class_2487 chunkTagData) {
        class_3218 mcServerLevel = this.params.mcServerLevel;
        if (chunkTagData == null) {
            return this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
        }
        try {
            ChunkWrapper chunkWrapper = ChunkCompoundTagParser.createFromTag((class_5281)mcServerLevel, this.params.dhServerLevel, chunkPos, chunkTagData);
            if (chunkWrapper == null) {
                chunkWrapper = this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
            }
            return chunkWrapper;
        }
        catch (Exception e) {
            CHUNK_LOAD_LOGGER.error("DistantHorizons: couldn't load or make chunk at [" + String.valueOf(chunkPos) + "].Please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.\nError: [" + e.getMessage() + "].", e);
            return this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
        }
    }

    public ChunkWrapper CreateProtoChunkWrapper(class_3218 level, class_1923 chunkPos) {
        class_2839 chunk = ChunkFileReader.CreateProtoChunk(level, chunkPos);
        return new ChunkWrapper((class_2791)chunk, this.params.dhServerLevel.getLevelWrapper(), false);
    }

    public static class_2839 CreateProtoChunk(class_3218 level, class_1923 chunkPos) {
        return new class_2839(chunkPos, class_2843.field_12950, (class_5539)level, level.method_30349().method_30530(class_7924.field_41236), null);
    }

    @Override
    public void close() {
        RegionFileStorageExternalCache regionStorage = this.regionFileStorageCacheRef.get();
        if (regionStorage != null) {
            try {
                regionStorage.close();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException e) {
                LOGGER.error("Failed to close region file storage cache, error: [" + e.getMessage() + "].", e);
            }
        }
    }
}

