/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiChunkModifiedEvent;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.renderer.generic.CloudRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.sql.repo.ChunkHashRepo;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhLevel
implements IDhLevel {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    @Nullable
    public ChunkHashRepo chunkHashRepo;
    @Nullable
    public BeaconBeamRepo beaconBeamRepo;
    protected final KeyedLockContainer<Long> beaconUpdateLockContainer = new KeyedLockContainer();
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSaveAsync, 3000);
    protected final ConcurrentHashMap<Long, HashSet<DhChunkPos>> updatedChunkPosSetBySectionPos = new ConcurrentHashMap();
    protected final ConcurrentHashMap<DhChunkPos, Integer> updatedChunkHashesByChunkPos = new ConcurrentHashMap();
    @Nullable
    protected CloudRenderHandler cloudRenderHandler;

    protected AbstractDhLevel() {
    }

    protected void createAndSetSupportingRepos(File databaseFile) {
        ChunkHashRepo newChunkHashRepo = null;
        try {
            newChunkHashRepo = new ChunkHashRepo("jdbc:dh_sqlite", databaseFile);
        }
        catch (IOException | SQLException e) {
            LOGGER.fatal("Unable to create [" + ChunkHashRepo.class.getSimpleName() + "], error: [" + e.getMessage() + "].", e);
        }
        this.chunkHashRepo = newChunkHashRepo;
        BeaconBeamRepo newBeaconBeamRepo = null;
        try {
            newBeaconBeamRepo = new BeaconBeamRepo("jdbc:dh_sqlite", databaseFile);
        }
        catch (IOException | SQLException e) {
            LOGGER.error("Unable to create [" + BeaconBeamRepo.class.getSimpleName() + "], error: [" + e.getMessage() + "].", e);
        }
        this.beaconBeamRepo = newBeaconBeamRepo;
    }

    protected void runRepoReliantSetup() {
        GenericObjectRenderer genericRenderer = this.getGenericRenderer();
        if (genericRenderer != null && this instanceof IDhClientLevel && !this.getLevelWrapper().hasCeiling() && !this.getLevelWrapper().getDimensionType().isTheEnd()) {
            this.cloudRenderHandler = new CloudRenderHandler((IDhClientLevel)((Object)this), genericRenderer);
        }
    }

    @Override
    public void updateChunkAsync(IChunkWrapper chunkWrapper, int chunkHash) {
        try (FullDataSourceV2 dataSource = FullDataSourceV2.createFromChunk(this.getLevelWrapper(), chunkWrapper);){
            if (dataSource == null) {
                return;
            }
            this.updatedChunkPosSetBySectionPos.compute(dataSource.getPos(), (dataSourcePos, chunkPosSet) -> {
                if (chunkPosSet == null) {
                    chunkPosSet = new HashSet<DhChunkPos>();
                }
                chunkPosSet.add(chunkWrapper.getChunkPos());
                return chunkPosSet;
            });
            this.updatedChunkHashesByChunkPos.put(chunkWrapper.getChunkPos(), chunkHash);
            this.delayedFullDataSourceSaveCache.writeDataSourceToMemoryAndQueueSave(dataSource);
        }
    }

    private CompletableFuture<Void> onDataSourceSaveAsync(FullDataSourceV2 fullDataSource) {
        DhLightingEngine.INSTANCE.bakeDataSourceSkyLight(fullDataSource, this.getLevelWrapper().hasSkyLight() ? 15 : 0);
        return this.updateDataSourcesAsync(fullDataSource).thenRun(() -> {
            HashSet<DhChunkPos> updatedChunkPosSet = this.updatedChunkPosSetBySectionPos.remove(fullDataSource.getPos());
            if (updatedChunkPosSet != null) {
                for (DhChunkPos chunkPos : updatedChunkPosSet) {
                    Integer chunkHash = this.updatedChunkHashesByChunkPos.remove(chunkPos);
                    if (this.chunkHashRepo != null && chunkHash != null) {
                        this.chunkHashRepo.save(new ChunkHashDTO(chunkPos, chunkHash));
                    }
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiChunkModifiedEvent.class, new DhApiChunkModifiedEvent.EventParam(this.getLevelWrapper(), chunkPos.getX(), chunkPos.getZ()));
                }
            }
        });
    }

    @Override
    public int getChunkHash(DhChunkPos pos) {
        if (this.chunkHashRepo == null) {
            return 0;
        }
        ChunkHashDTO dto = (ChunkHashDTO)this.chunkHashRepo.getByKey(pos);
        return dto != null ? dto.chunkHash : 0;
    }

    @Override
    public void updateBeaconBeamsForSectionPos(long sectionPos, List<BeaconBeamDTO> activeBeamList) {
        int minBlockX = DhSectionPos.getMinCornerBlockX(sectionPos);
        int minBlockZ = DhSectionPos.getMinCornerBlockZ(sectionPos);
        int maxBlockX = minBlockX + DhSectionPos.getBlockWidth(sectionPos);
        int maxBlockZ = minBlockZ + DhSectionPos.getBlockWidth(sectionPos);
        this.updateBeaconBeamsBetweenBlockPos(sectionPos, minBlockX, maxBlockX, minBlockZ, maxBlockZ, activeBeamList);
    }

    @Override
    public void updateBeaconBeamsForChunkPos(DhChunkPos chunkPos, List<BeaconBeamDTO> activeBeamList) {
        long sectionPos = DhSectionPos.encodeContaining((byte)6, chunkPos);
        int minBlockX = chunkPos.getMinBlockX();
        int minBlockZ = chunkPos.getMinBlockZ();
        int maxBlockX = chunkPos.getMaxBlockX();
        int maxBlockZ = chunkPos.getMaxBlockZ();
        this.updateBeaconBeamsBetweenBlockPos(sectionPos, minBlockX, maxBlockX, minBlockZ, maxBlockZ, activeBeamList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBeaconBeamsBetweenBlockPos(long sectionPosForLock, int minBlockX, int maxBlockX, int minBlockZ, int maxBlockZ, List<BeaconBeamDTO> activeBeamList) {
        if (this.beaconBeamRepo == null) {
            return;
        }
        ReentrantLock lock = this.beaconUpdateLockContainer.getLockForPos(sectionPosForLock);
        try {
            lock.lock();
            HashSet<DhBlockPos> allPosSet = new HashSet<DhBlockPos>();
            HashMap<DhBlockPos, BeaconBeamDTO> activeBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(activeBeamList.size());
            for (BeaconBeamDTO beam : activeBeamList) {
                activeBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsInBlockPosRange(minBlockX, maxBlockX, minBlockZ, maxBlockZ);
            HashMap<DhBlockPos, BeaconBeamDTO> existingBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(existingBeamList.size());
            for (BeaconBeamDTO beam : existingBeamList) {
                existingBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            for (DhBlockPos beaconPos : allPosSet) {
                if (minBlockX > beaconPos.getX() || beaconPos.getX() > maxBlockX || minBlockZ > beaconPos.getZ() || beaconPos.getZ() > maxBlockZ) continue;
                BeaconBeamDTO existingBeam = (BeaconBeamDTO)existingBeamByPos.get(beaconPos);
                BeaconBeamDTO activeBeam = (BeaconBeamDTO)activeBeamByPos.get(beaconPos);
                if (activeBeam != null) {
                    if (existingBeam == null) {
                        this.beaconBeamRepo.save(activeBeam);
                        continue;
                    }
                    if (existingBeam.color.equals(activeBeam.color)) continue;
                    this.beaconBeamRepo.save(activeBeam);
                    continue;
                }
                if (existingBeam == null) continue;
                this.beaconBeamRepo.deleteWithKey(beaconPos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nullable
    public BeaconBeamRepo getBeaconBeamRepo() {
        return this.beaconBeamRepo;
    }

    @Override
    public void close() {
        if (this.chunkHashRepo != null) {
            this.chunkHashRepo.close();
        }
        if (this.beaconBeamRepo != null) {
            this.beaconBeamRepo.close();
        }
        this.delayedFullDataSourceSaveCache.close();
    }
}

