/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile.V2;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.IDataSourceUpdateListenerFunc;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.DataMigratorV1;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataUpdatePropagatorV2;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataUpdaterV2;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceProviderV2
implements IDebugRenderable,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Set<String> CORRUPT_DATA_ERRORS_LOGGED = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final byte ROOT_SECTION_DETAIL_LEVEL = 15;
    public static final byte LEAF_SECTION_DETAIL_LEVEL = 6;
    public final FullDataSourceV2Repo repo;
    protected final AtomicBoolean isShutdownRef = new AtomicBoolean(false);
    protected final File saveDir;
    protected final IDhLevel level;
    protected final String levelId;
    private final FullDataUpdaterV2 dataUpdater;
    private final FullDataUpdatePropagatorV2 updatePropagator;
    private final DataMigratorV1 dataMigratorV1;

    public FullDataSourceProviderV2(IDhLevel level, ISaveStructure saveStructure) throws SQLException, IOException {
        this(level, saveStructure, null);
    }

    public FullDataSourceProviderV2(IDhLevel level, ISaveStructure saveStructure, @Nullable File saveDirOverride) throws SQLException, IOException {
        this.saveDir = saveDirOverride == null ? saveStructure.getSaveFolder(level.getLevelWrapper()) : saveDirOverride;
        this.repo = new FullDataSourceV2Repo("jdbc:dh_sqlite", new File(this.saveDir.getPath() + File.separator + "DistantHorizons.sqlite"));
        this.level = level;
        this.levelId = this.level.getLevelWrapper().getDhIdentifier();
        this.dataUpdater = new FullDataUpdaterV2(this, this.levelId);
        this.updatePropagator = new FullDataUpdatePropagatorV2(this, this.dataUpdater, this.levelId);
        this.dataMigratorV1 = new DataMigratorV1(this.dataUpdater, this.level, this.levelId, this.saveDir);
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showFullDataUpdateStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceUpdateListener(IDataSourceUpdateListenerFunc<FullDataSourceV2> listener) {
        ArrayList<IDataSourceUpdateListenerFunc<FullDataSourceV2>> arrayList = this.dataUpdater.dateSourceUpdateListeners;
        synchronized (arrayList) {
            this.dataUpdater.dateSourceUpdateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSourceUpdateListener(IDataSourceUpdateListenerFunc<FullDataSourceV2> listener) {
        ArrayList<IDataSourceUpdateListenerFunc<FullDataSourceV2>> arrayList = this.dataUpdater.dateSourceUpdateListeners;
        synchronized (arrayList) {
            this.dataUpdater.dateSourceUpdateListeners.add(listener);
        }
    }

    protected FullDataSourceV2 createDataSourceFromDto(FullDataSourceV2DTO dto) throws InterruptedException, IOException, DataCorruptedException {
        return dto.createDataSource(this.level.getLevelWrapper(), null);
    }

    protected FullDataSourceV2 createAdjDataSourceFromDto(FullDataSourceV2DTO dto, EDhDirection direction) throws InterruptedException, IOException, DataCorruptedException {
        return dto.createDataSource(this.level.getLevelWrapper(), direction);
    }

    public CompletableFuture<FullDataSourceV2> getAsync(long pos) {
        if (this.isShutdownRef.get()) {
            return CompletableFuture.completedFuture(null);
        }
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return CompletableFuture.supplyAsync(() -> this.get(pos), executor);
        }
        catch (RejectedExecutionException ignore) {
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public FullDataSourceV2 get(long pos) {
        if (this.isShutdownRef.get()) {
            return null;
        }
        try (FullDataSourceV2DTO dto2222 = (FullDataSourceV2DTO)this.repo.getByKey(pos);){
            if (dto2222 == null) {
                FullDataSourceV2 fullDataSourceV22 = FullDataSourceV2.createEmpty(pos);
                return fullDataSourceV22;
            }
            FullDataSourceV2 dataSource = this.createDataSourceFromDto(dto2222);
            if (dto2222.dataFormatVersion == 1) {
                EDhApiDataCompressionMode compressionMode = Config.Common.LodBuilding.dataCompression.get();
                try (FullDataSourceV2DTO updatedDto = FullDataSourceV2DTO.CreateFromDataSource(dataSource, compressionMode);){
                    this.repo.save(updatedDto);
                }
            }
            FullDataSourceV2 fullDataSourceV2 = dataSource;
            return fullDataSourceV2;
        }
        catch (InterruptedException dto2222) {
            return null;
        }
        catch (IOException e3) {
            String message = e3.getMessage();
            if (!CORRUPT_DATA_ERRORS_LOGGED.add(message)) return null;
            LOGGER.warn("File read Error for pos [" + DhSectionPos.toString(pos) + "], this error message will only be logged once, error: [" + message + "].", e3);
            return null;
        }
        catch (IllegalStateException e4) {
            String message = e4.getMessage();
            if (!CORRUPT_DATA_ERRORS_LOGGED.add(message)) return null;
            LOGGER.warn("Incorrectly formatted data for: [" + DhSectionPos.toString(pos) + "], this error message will only be logged once, error: [" + message + "].", e4);
            return null;
        }
        catch (Exception e5) {
            String message = e5.getMessage();
            if (!CORRUPT_DATA_ERRORS_LOGGED.add(message)) return null;
            LOGGER.warn("Unexpected error getting: [" + DhSectionPos.toString(pos) + "], this error message will only be logged once, error: [" + message + "].", e5);
        }
        return null;
    }

    protected void tryLogCorruptedDataError(String whereClause, Exception e) {
        String message;
        String string = message = e.getMessage() == null ? e.getMessage() : "No Error message for exception [" + e.getClass().getSimpleName() + "]";
        if (CORRUPT_DATA_ERRORS_LOGGED.add(message)) {
            LOGGER.warn("Corrupted data found at [" + whereClause + "]. Data at will be deleted so it can be re-generated to prevent issues. Future errors with this same message won't be logged. Error: [" + message + "].", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FullDataSourceV2 getAdjForDirection(long pos, EDhDirection direction) {
        if (this.isShutdownRef.get()) {
            return null;
        }
        try (FullDataSourceV2DTO dto2 = this.repo.getAdjByPosAndDirection(pos, direction);){
            if (dto2 == null) {
                FullDataSourceV2 fullDataSourceV2 = FullDataSourceV2.createEmpty(pos);
                return fullDataSourceV2;
            }
            if (dto2.dataFormatVersion == 1) {
                FullDataSourceV2 migratedDataSource = this.get(pos);
                if (migratedDataSource != null) {
                    migratedDataSource.clearAllNonAdjData(direction);
                }
                FullDataSourceV2 fullDataSourceV2 = migratedDataSource;
                return fullDataSourceV2;
            }
            FullDataSourceV2 migratedDataSource = this.createAdjDataSourceFromDto(dto2, direction);
            return migratedDataSource;
        }
        catch (InterruptedException dto2) {
            return null;
        }
        catch (IOException e) {
            LOGGER.warn("File read Error for pos [" + DhSectionPos.toString(pos) + "], error: " + e.getMessage(), e);
        }
        return null;
    }

    public boolean canRetrieveMissingDataSources() {
        return false;
    }

    public boolean canQueueRetrieval() {
        return !this.dataMigratorV1.migrationThreadRunning.get();
    }

    @Nullable
    public LongArrayList getPositionsToRetrieve(Long pos) {
        return null;
    }

    @Nullable
    public CompletableFuture<WorldGenResult> queuePositionForRetrieval(Long genPos) {
        return null;
    }

    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
    }

    public void clearRetrievalQueue() {
    }

    public void setTotalRetrievalPositionCount(int newCount) {
    }

    public void setEstimatedRemainingRetrievalChunkCount(int newCount) {
    }

    public CompletableFuture<Void> updateDataSourceAsync(@NotNull FullDataSourceV2 inputData) {
        return this.dataUpdater.updateDataSourceAsync(inputData);
    }

    @Nullable
    public Long getTimestampForPos(long pos) {
        if (this.isShutdownRef.get()) {
            return null;
        }
        return this.repo.getTimestampForPos(pos);
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        this.dataMigratorV1.addDebugMenuStringsToList(messageList);
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        this.dataUpdater.debugRender(renderer);
        this.updatePropagator.debugRender(renderer);
        this.dataMigratorV1.debugRender(renderer);
    }

    @Override
    public void close() {
        LOGGER.debug("Closing [" + this.getClass().getSimpleName() + "] for level: [" + this.levelId + "].", new Object[0]);
        this.isShutdownRef.set(true);
        this.dataUpdater.close();
        this.updatePropagator.close();
        this.dataMigratorV1.close();
        this.repo.close();
    }
}

