/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.event;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="backported_animal_variants", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        if (!sheep.isSheared()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (!(item instanceof DyeItem)) {
            return;
        }
        DyeItem dyeItem = (DyeItem)item;
        if (sheep.getColor() == dyeItem.getDyeColor()) {
            return;
        }
        if (!player.level().isClientSide) {
            sheep.setColor(dyeItem.getDyeColor());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            sheep.level().playSound(null, sheep.blockPosition(), SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            sheep.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)player);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

