/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.akaciobahno.backported_animal_variants.entity.client.CustomCowModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomMooshroomLayer<T extends MushroomCow>
extends RenderLayer<T, CustomCowModel<T>> {
    private final BlockRenderDispatcher blockRenderer;

    public CustomMooshroomLayer(RenderLayerParent<T, CustomCowModel<T>> pRenderer, BlockRenderDispatcher pBlockRenderer) {
        super(pRenderer);
        this.blockRenderer = pBlockRenderer;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!pLivingEntity.isBaby()) {
            boolean flag;
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = flag = minecraft.shouldEntityAppearGlowing(pLivingEntity) && pLivingEntity.isInvisible();
            if (!pLivingEntity.isInvisible() || flag) {
                BlockState blockstate = pLivingEntity.getVariant().getBlockState();
                int i = LivingEntityRenderer.getOverlayCoords(pLivingEntity, (float)0.0f);
                BakedModel bakedmodel = this.blockRenderer.getBlockModel(blockstate);
                pPoseStack.pushPose();
                pPoseStack.translate(0.2f, -0.35f, 0.5f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
                pPoseStack.scale(-1.0f, -1.0f, 1.0f);
                pPoseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderMushroomBlock(pPoseStack, pBuffer, pPackedLight, flag, blockstate, i, bakedmodel);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                pPoseStack.translate(0.2f, -0.35f, 0.5f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(42.0f));
                pPoseStack.translate(0.1f, 0.0f, -0.6f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
                pPoseStack.scale(-1.0f, -1.0f, 1.0f);
                pPoseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderMushroomBlock(pPoseStack, pBuffer, pPackedLight, flag, blockstate, i, bakedmodel);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                ((CustomCowModel)this.getParentModel()).getHead().translateAndRotate(pPoseStack);
                pPoseStack.translate(0.0f, -0.7f, -0.2f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-78.0f));
                pPoseStack.scale(-1.0f, -1.0f, 1.0f);
                pPoseStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderMushroomBlock(pPoseStack, pBuffer, pPackedLight, flag, blockstate, i, bakedmodel);
                pPoseStack.popPose();
            }
        }
    }

    private void renderMushroomBlock(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, boolean pOutlineOnly, BlockState pState, int pPackedOverlay, BakedModel pModel) {
        if (pOutlineOnly) {
            this.blockRenderer.getModelRenderer().renderModel(pPoseStack.last(), pBuffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), pState, pModel, 0.0f, 0.0f, 0.0f, pPackedLight, pPackedOverlay);
        } else {
            this.blockRenderer.renderSingleBlock(pState, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }
}

