/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.client;

import com.google.common.collect.ImmutableList;
import net.akaciobahno.backported_animal_variants.entity.custom.ColdChicken;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ColdChickenModel<T extends ColdChicken>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart comb;
    private final ModelPart beak;
    private final ModelPart hair;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart right_wing;
    private final ModelPart left_wing;

    public ColdChickenModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.head = root.getChild("head");
        this.comb = root.getChild("comb");
        this.beak = root.getChild("beak");
        this.hair = root.getChild("hair");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
        this.right_wing = root.getChild("right_wing");
        this.left_wing = root.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 16;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("comb", CubeListBuilder.create().texOffs(14, 4).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(40, 14).addBox(-4.0f, 0.0f, -1.0f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)5.0f, (float)3.1416f, (float)0.0f, (float)-1.5708f));
        partdefinition.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(44, 0).addBox(-3.0f, -7.0f, -2.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.02f));
        partdefinition.addOrReplaceChild("right_leg", cubelistbuilder, PartPose.offset((float)-2.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("left_leg", cubelistbuilder, PartPose.offset((float)1.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)-4.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)4.0f, (float)13.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.beak.xRot = this.head.xRot;
        this.beak.yRot = this.head.yRot;
        this.comb.xRot = this.head.xRot;
        this.comb.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.hair.yRot = this.head.yRot;
        this.right_leg.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.right_wing.zRot = pAgeInTicks;
        this.left_wing.zRot = -pAgeInTicks;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.beak, (Object)this.comb, (Object)this.hair);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.right_leg, (Object)this.left_leg, (Object)this.right_wing, (Object)this.left_wing, (Object)this.tail);
    }
}

