/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.encryption;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.encryption.EncryptionManager;
import su.plo.voice.api.encryption.EncryptionSupplier;

public final class VoiceEncryptionManager
implements EncryptionManager {
    private final Map<String, EncryptionSupplier> algorithms = Maps.newHashMap();

    @Override
    @NotNull
    public synchronized Encryption create(@NotNull String name, byte[] data) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)data, (Object)"params cannot be null");
        EncryptionSupplier supplier = this.algorithms.get(name);
        if (supplier == null) {
            throw new IllegalArgumentException("Encryption algorithm with name " + name + " is not registered");
        }
        return supplier.create(data);
    }

    @Override
    public synchronized void register(@NotNull EncryptionSupplier supplier) {
        String name = supplier.getName();
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier cannot be null");
        if (this.algorithms.containsKey(name)) {
            throw new IllegalArgumentException("Encryption algorithm with name " + name + " is already exist");
        }
        this.algorithms.put(name, supplier);
    }

    @Override
    public synchronized boolean unregister(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this.algorithms.remove(name) != null;
    }

    @Override
    public synchronized boolean unregister(@NotNull EncryptionSupplier supplier) {
        String name = supplier.getName();
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this.algorithms.remove(name) != null;
    }

    @Override
    public synchronized Collection<EncryptionSupplier> getAlgorithms() {
        return this.algorithms.values();
    }
}

