/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.lib.mod.client.render.particle.BlockDustParticle2D;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.util.RandomUtil;

public final class VoiceSettingsAboutFeature {
    private final VoiceSettingsScreen parent;
    private final List<BlockDustParticle2D> particles = Lists.newArrayList();
    private int clickCount;
    private long lastClick;

    public void tick() {
        this.particles.removeAll(this.particles.stream().filter(particle -> {
            particle.tick();
            return !particle.isAlive();
        }).collect(Collectors.toList()));
        if (System.currentTimeMillis() - this.lastClick > 5000L) {
            this.clickCount = 0;
        }
    }

    public void titleClicked() {
        if (this.clickCount > 10) {
            this.parent.getNavigation().openTab(-1);
            this.lastClick = 0L;
            this.clickCount = 0;
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.25f));
            return;
        }
        this.lastClick = System.currentTimeMillis();
        ++this.clickCount;
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.GRAVEL_HIT, (float)1.0f, (float)1.0f));
        for (int i = 0; i < 2 + RandomUtil.randomInt(3); ++i) {
            BlockDustParticle2D particle = new BlockDustParticle2D(14 + RandomUtil.randomInt(this.parent.getTitleWidth()), 15 + RandomUtil.randomInt(RenderUtil.getFontHeight()), 0.0, 0.0, Blocks.DIRT.defaultBlockState());
            particle.setMaxAge(10 + RandomUtil.randomInt(25));
            particle.setVelocity(RandomUtil.randomFloat(-0.25f, 0.25f), -0.25);
            particle.setGravityStrength(4.0f);
            particle.setScale(RandomUtil.randomFloat(1.5f, 2.5f));
            this.particles.add(particle);
        }
    }

    public void render(@NotNull GuiRenderContext context, float delta) {
        for (BlockDustParticle2D particle : this.particles) {
            ResourceLocation textureLocation = particle.getSprite().atlasLocation();
            particle.render(context, textureLocation, delta);
        }
    }

    public VoiceSettingsAboutFeature(VoiceSettingsScreen parent) {
        this.parent = parent;
    }
}

