/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device.source;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL11;
import org.lwjgl.system.MemoryUtil;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.event.audio.device.source.AlSourceBufferQueuedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceBufferUnqueuedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceClosedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceCreatedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourcePauseEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourcePlayEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceStopEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceWriteEvent;
import su.plo.voice.api.client.event.audio.device.source.AlStreamSourceStoppedEvent;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.audio.AlUtil;
import su.plo.voice.client.audio.device.AlOutputDevice;
import su.plo.voice.client.audio.device.source.BaseAlSource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.jvm.JvmStatic;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlinx.coroutines.BuildersKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.libs.kotlinx.coroutines.DelayKt;
import su.plo.voice.libs.kotlinx.coroutines.Job;
import su.plo.voice.libs.kotlinx.coroutines.future.FutureKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 92\u00020\u0001:\u00019B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\u0018\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0019H\u0016J\b\u0010,\u001a\u00020\"H\u0016J\u000e\u0010-\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010100H\u0016J\b\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\"H\u0002J\b\u00104\u001a\u00020\"H\u0002J\b\u00105\u001a\u00020\"H\u0002J\u0010\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\tH\u0002J\b\u00108\u001a\u00020\"H\u0002R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lsu/plo/voice/client/audio/device/source/StreamAlSource;", "Lsu/plo/voice/client/audio/device/source/BaseAlSource;", "client", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "device", "Lsu/plo/voice/client/audio/device/AlOutputDevice;", "stereo", "", "numBuffers", "", "pointer", "<init>", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Lsu/plo/voice/client/audio/device/AlOutputDevice;ZII)V", "timeSupplier", "Lsu/plo/voice/api/client/time/TimeSupplier;", "getTimeSupplier", "()Lsu/plo/voice/api/client/time/TimeSupplier;", "closeTimeoutMs", "", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/nio/ByteBuffer;", "isStreaming", "Ljava/util/concurrent/atomic/AtomicBoolean;", "emptyBuffer", "", "job", "Lsu/plo/voice/libs/kotlinx/coroutines/Job;", "buffers", "", "availableBuffer", "emptyFilled", "lastBufferTime", "play", "", "stop", "pause", "setCloseTimeoutMs", "timeoutMs", "updateLastBufferTime", "write", "samples", "", "applyFilters", "clearBuffer", "close", "(Lsu/plo/voice/libs/kotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "closeSync", "startStreamThread", "queueWithEmptyBuffers", "fillQueue", "fillAndPushBuffer", "buffer", "removeProcessedBuffers", "Companion", "plasmovoice-neoforge-1.21"})
public final class StreamAlSource
extends BaseAlSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long closeTimeoutMs = 25000L;
    private final int numBuffers;
    @NotNull
    private final LinkedBlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue();
    @NotNull
    private final AtomicBoolean isStreaming = new AtomicBoolean(false);
    @NotNull
    private final byte[] emptyBuffer;
    @Nullable
    private Job job;
    private int[] buffers;
    @NotNull
    private final int[] availableBuffer = new int[1];
    @NotNull
    private final AtomicBoolean emptyFilled = new AtomicBoolean(false);
    private long lastBufferTime;
    private static final Logger LOGGER = LogManager.getLogger(StreamAlSource.class);

    private StreamAlSource(PlasmoVoiceClient client, AlOutputDevice device, boolean stereo, int numBuffers, int pointer) {
        super(client, device, stereo, pointer);
        int n;
        if (numBuffers == 0) {
            Object e = client.getConfig().getAdvanced().getAlPlaybackBuffers().value();
            Intrinsics.checkNotNullExpressionValue(e, "value(...)");
            n = ((Number)e).intValue();
        } else {
            n = numBuffers;
        }
        this.numBuffers = n;
        this.emptyBuffer = new byte[device.getFrameSize()];
    }

    private final TimeSupplier getTimeSupplier() {
        TimeSupplier timeSupplier = this.client.getTimeSupplier();
        Intrinsics.checkNotNullExpressionValue(timeSupplier, "getTimeSupplier(...)");
        return timeSupplier;
    }

    @Override
    public void play() {
        AlUtil.checkDeviceContext(this.device);
        if (!this.client.getEventBus().fire((Event)new AlSourcePlayEvent(this))) {
            return;
        }
        boolean isStreaming = this.isStreaming.get();
        AlSource.State state = this.getState();
        Intrinsics.checkNotNullExpressionValue((Object)state, "getState(...)");
        AlSource.State state2 = state;
        if (isStreaming && state2 == AlSource.State.PAUSED) {
            AL11.alSourcePlay((int)this.pointer);
            AlUtil.checkErrors("Source play");
            return;
        }
        if (isStreaming) {
            return;
        }
        this.startStreamThread();
    }

    @Override
    public void stop() {
        AlSourceStopEvent alSourceStopEvent;
        AlUtil.checkDeviceContext(this.device);
        AlSourceStopEvent it = alSourceStopEvent = new AlSourceStopEvent(this);
        boolean bl = false;
        if (!this.client.getEventBus().fire((Event)it)) {
            return;
        }
        AL11.alSourceStop((int)this.pointer);
        AlUtil.checkErrors("Source stop");
        this.isStreaming.set(false);
        this.queue.clear();
    }

    @Override
    public void pause() {
        AlSourcePauseEvent alSourcePauseEvent;
        AlUtil.checkDeviceContext(this.device);
        AlSourcePauseEvent it = alSourcePauseEvent = new AlSourcePauseEvent(this);
        boolean bl = false;
        if (!this.client.getEventBus().fire((Event)it)) {
            return;
        }
        AL11.alSourcePause((int)this.pointer);
        AlUtil.checkErrors("Source pause");
    }

    @Override
    public void setCloseTimeoutMs(long timeoutMs) {
        this.closeTimeoutMs = timeoutMs;
    }

    @Override
    public void updateLastBufferTime() {
        this.lastBufferTime = this.getTimeSupplier().getCurrentTimeMillis();
    }

    @Override
    public void write(@NotNull short[] samples, boolean applyFilters) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        short[] processedSamples = applyFilters ? this.device.processFilters(samples) : samples;
        byte[] byArray = AudioUtil.shortsToBytes(processedSamples);
        Intrinsics.checkNotNullExpressionValue(byArray, "shortsToBytes(...)");
        this.write(byArray);
    }

    @Override
    public void write(@NotNull byte[] samples) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        if (!this.isStreaming.get()) {
            return;
        }
        if (samples.length == 0) {
            this.write(this.emptyBuffer);
            return;
        }
        if (this.queue.size() > 100) {
            BaseVoice.DEBUG_LOGGER.log("Queue overflow, dropping samples", new Object[0]);
            return;
        }
        AlSourceWriteEvent writeEvent = new AlSourceWriteEvent(this, samples);
        if (!this.client.getEventBus().fire((Event)writeEvent)) {
            return;
        }
        byte[] byArray = writeEvent.getSamples();
        Intrinsics.checkNotNullExpressionValue(byArray, "getSamples(...)");
        byte[] newSamples = byArray;
        ByteBuffer buffer = MemoryUtil.memAlloc((int)newSamples.length);
        buffer.put(newSamples);
        Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)buffer).flip();
        this.queue.offer(buffer);
        if (!Intrinsics.areEqual(newSamples, this.emptyBuffer)) {
            this.emptyFilled.set(false);
            this.lastBufferTime = this.getTimeSupplier().getCurrentTimeMillis();
        }
    }

    @Override
    public void clearBuffer() {
        if (this.queue.isEmpty()) {
            return;
        }
        this.queue.clear();
    }

    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        if (!this.isStreaming.get()) {
            return Unit.INSTANCE;
        }
        Object object = this.device.runInContext((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StreamAlSource.access$closeSync(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> closeAsync() {
        if (!this.isStreaming.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
            return completableFuture;
        }
        return FutureKt.future$default(this.device.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Void>, Object>(this, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StreamAlSource.access$closeSync(this.this$0);
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Void> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void closeSync() {
        this.stop();
        if (this.getState() == AlSource.State.INITIAL) {
            AL11.alSourcePlay((int)this.pointer);
            AlUtil.checkErrors("Source play");
            AL11.alSourceStop((int)this.pointer);
            AlUtil.checkErrors("Source stop");
        }
        this.client.getEventBus().fire((Event)new AlSourceClosedEvent(this));
        this.removeProcessedBuffers();
        int[] nArray = this.buffers;
        if (this.buffers == null) {
            Intrinsics.throwUninitializedPropertyAccessException("buffers");
            nArray = null;
        }
        AL11.alDeleteBuffers((int[])nArray);
        AlUtil.checkErrors("Delete buffers");
        int[] nArray2 = new int[]{this.pointer};
        AL11.alDeleteSources((int[])nArray2);
        AlUtil.checkErrors("Delete source");
        this.pointer = 0;
    }

    private final void startStreamThread() {
        this.isStreaming.set(true);
        StreamAlSource alSource = this;
        this.job = BuildersKt.launch$default(this.device.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, alSource, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            final /* synthetic */ StreamAlSource $alSource;
            {
                this.this$0 = $receiver;
                this.$alSource = $alSource;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                Object object3;
                Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StreamAlSource.access$setBuffers$p(this.this$0, new int[StreamAlSource.access$getNumBuffers$p(this.this$0)]);
                        int[] nArray = StreamAlSource.access$getBuffers$p(this.this$0);
                        if (nArray == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("buffers");
                            nArray = null;
                        }
                        AL11.alGenBuffers((int[])nArray);
                        AlUtil.checkErrors("Source gen buffers");
                        StreamAlSource.access$queueWithEmptyBuffers(this.this$0);
                        StreamAlSource.access$fillQueue(this.this$0);
                        this.this$0.updateLastBufferTime();
                        StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
                        break;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        object3 = $result;
                        return Unit.INSTANCE;
                    }
                    case 2: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (StreamAlSource.access$isStreaming$p(this.this$0).get()) {
                    AlSource.State state;
                    int queueSize = StreamAlSource.access$getQueue$p(this.this$0).size();
                    int processedBuffers = this.this$0.getInt(4118);
                    AlUtil.checkErrors("Get processed buffers");
                    while (processedBuffers > 0 || StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] != -1) {
                        if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] == -1) {
                            AL11.alSourceUnqueueBuffers((int)this.this$0.pointer, (int[])StreamAlSource.access$getAvailableBuffer$p(this.this$0));
                            AlUtil.checkErrors("Unqueue buffer");
                            int bits = AL11.alGetBufferi((int)StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0], (int)8194);
                            AlUtil.checkErrors("Source get buffer int");
                            if (bits == 0) {
                                StreamAlSource.access$getLOGGER$cp().warn("Corrupted stream");
                                continue;
                            }
                            if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] != -1) {
                                AlSourceBufferUnqueuedEvent unqueuedEvent = new AlSourceBufferUnqueuedEvent(this.$alSource, StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0]);
                                this.this$0.client.getEventBus().fire((Event)unqueuedEvent);
                            }
                        }
                        if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] == -1 || !StreamAlSource.access$fillAndPushBuffer(this.this$0, StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0])) break;
                        StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
                        --processedBuffers;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)this.this$0.getState()), "getState(...)");
                    if (state == AlSource.State.STOPPED && queueSize == 0 && !StreamAlSource.access$getEmptyFilled$p(this.this$0).get()) {
                        StreamAlSource.access$removeProcessedBuffers(this.this$0);
                        StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
                        StreamAlSource.access$queueWithEmptyBuffers(this.this$0);
                        StreamAlSource.access$fillQueue(this.this$0);
                        this.this$0.client.getEventBus().fire((Event)new AlStreamSourceStoppedEvent(this.$alSource));
                        continue;
                    }
                    if (state != AlSource.State.PLAYING && state != AlSource.State.PAUSED && queueSize > 0) {
                        AL11.alSourcePlay((int)this.this$0.pointer);
                        AlUtil.checkErrors("Source play");
                        continue;
                    }
                    if (state == AlSource.State.INITIAL) {
                        AL11.alSourcePlay((int)this.this$0.pointer);
                        AlUtil.checkErrors("Source play");
                        continue;
                    }
                    if (StreamAlSource.access$getCloseTimeoutMs$p(this.this$0) > 0L && StreamAlSource.access$getTimeSupplier(this.this$0).getCurrentTimeMillis() - StreamAlSource.access$getLastBufferTime$p(this.this$0) > StreamAlSource.access$getCloseTimeoutMs$p(this.this$0)) {
                        BaseVoice.DEBUG_LOGGER.log("Stream timed out. Closing...", new Object[0]);
                        this.label = 1;
                        Object object5 = this.this$0.close((Continuation<? super Unit>)this);
                        object3 = object5;
                        if (object5 != object4) return Unit.INSTANCE;
                        return object4;
                    }
                    this.label = 2;
                    object2 = DelayKt.delay(5L, this);
                    if (object2 == object4) return object4;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void queueWithEmptyBuffers() {
        int n = this.numBuffers;
        for (int i = 0; i < n; ++i) {
            this.write(this.emptyBuffer);
        }
        this.emptyFilled.set(true);
    }

    private final void fillQueue() {
        int n = this.numBuffers;
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.buffers;
            if (this.buffers == null) {
                Intrinsics.throwUninitializedPropertyAccessException("buffers");
                nArray = null;
            }
            this.fillAndPushBuffer(nArray[i]);
        }
    }

    private final boolean fillAndPushBuffer(int buffer) {
        ByteBuffer byteBuffer = this.queue.poll();
        if (byteBuffer == null) {
            return false;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        AL11.alBufferData((int)buffer, (int)this.format, (ByteBuffer)byteBuffer2, (int)((int)this.device.getFormat().getSampleRate()));
        if (AlUtil.checkErrors("Assigning buffer data")) {
            return false;
        }
        int[] nArray = new int[]{buffer};
        AL11.alSourceQueueBuffers((int)this.pointer, (int[])nArray);
        if (AlUtil.checkErrors("Queue buffer data")) {
            return false;
        }
        this.client.getEventBus().fire((Event)new AlSourceBufferQueuedEvent(this, byteBuffer2, buffer));
        return true;
    }

    private final void removeProcessedBuffers() {
        AlUtil.checkErrors("Get processed buffers");
        for (int processedBuffers = this.getInt(4118); processedBuffers > 0; --processedBuffers) {
            int[] buffer = new int[1];
            AL11.alSourceUnqueueBuffers((int)this.pointer, (int[])buffer);
            AlUtil.checkErrors("Unqueue buffer");
        }
    }

    @JvmStatic
    @NotNull
    public static final AlSource create(@NotNull AlOutputDevice device, @NotNull PlasmoVoiceClient client, boolean stereo, int numBuffers) {
        return Companion.create(device, client, stereo, numBuffers);
    }

    public static final /* synthetic */ void access$closeSync(StreamAlSource $this) {
        $this.closeSync();
    }

    public static final /* synthetic */ void access$setBuffers$p(StreamAlSource $this, int[] nArray) {
        $this.buffers = nArray;
    }

    public static final /* synthetic */ int access$getNumBuffers$p(StreamAlSource $this) {
        return $this.numBuffers;
    }

    public static final /* synthetic */ int[] access$getBuffers$p(StreamAlSource $this) {
        return $this.buffers;
    }

    public static final /* synthetic */ void access$queueWithEmptyBuffers(StreamAlSource $this) {
        $this.queueWithEmptyBuffers();
    }

    public static final /* synthetic */ void access$fillQueue(StreamAlSource $this) {
        $this.fillQueue();
    }

    public static final /* synthetic */ int[] access$getAvailableBuffer$p(StreamAlSource $this) {
        return $this.availableBuffer;
    }

    public static final /* synthetic */ AtomicBoolean access$isStreaming$p(StreamAlSource $this) {
        return $this.isStreaming;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(StreamAlSource $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ boolean access$fillAndPushBuffer(StreamAlSource $this, int buffer) {
        return $this.fillAndPushBuffer(buffer);
    }

    public static final /* synthetic */ AtomicBoolean access$getEmptyFilled$p(StreamAlSource $this) {
        return $this.emptyFilled;
    }

    public static final /* synthetic */ void access$removeProcessedBuffers(StreamAlSource $this) {
        $this.removeProcessedBuffers();
    }

    public static final /* synthetic */ long access$getCloseTimeoutMs$p(StreamAlSource $this) {
        return $this.closeTimeoutMs;
    }

    public static final /* synthetic */ TimeSupplier access$getTimeSupplier(StreamAlSource $this) {
        return $this.getTimeSupplier();
    }

    public static final /* synthetic */ long access$getLastBufferTime$p(StreamAlSource $this) {
        return $this.lastBufferTime;
    }

    public /* synthetic */ StreamAlSource(PlasmoVoiceClient client, AlOutputDevice device, boolean stereo, int numBuffers, int pointer, DefaultConstructorMarker $constructor_marker) {
        this(client, device, stereo, numBuffers, pointer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lsu/plo/voice/client/audio/device/source/StreamAlSource$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "create", "Lsu/plo/voice/api/client/audio/device/source/AlSource;", "device", "Lsu/plo/voice/client/audio/device/AlOutputDevice;", "client", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "stereo", "", "numBuffers", "", "plasmovoice-neoforge-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AlSource create(@NotNull AlOutputDevice device, @NotNull PlasmoVoiceClient client, boolean stereo, int numBuffers) {
            StreamAlSource streamAlSource;
            Intrinsics.checkNotNullParameter(device, "device");
            Intrinsics.checkNotNullParameter(client, "client");
            AlUtil.checkDeviceContext(device);
            int[] pointer = new int[1];
            AL11.alGenSources((int[])pointer);
            if (AlUtil.checkErrors("Allocate new source")) {
                throw new DeviceException("Failed to allocate new source");
            }
            StreamAlSource source2 = streamAlSource = new StreamAlSource(client, device, stereo, numBuffers, pointer[0], null);
            boolean bl = false;
            client.getEventBus().fire((Event)new AlSourceCreatedEvent(source2));
            return streamAlSource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

