/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.provider;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import su.plo.config.Config;

public abstract class ConfigurationProvider {
    public static <T> T getProvider(@NotNull Class<? extends ConfigurationProvider> providerClass) {
        return ConfigurationProvider.getProvider(providerClass, providerClass.getClassLoader());
    }

    public static <T> T getProvider(@NotNull Class<? extends ConfigurationProvider> providerClass, @NotNull ClassLoader classLoader) {
        ServiceLoader<ConfigurationProvider> loader = ServiceLoader.load(ConfigurationProvider.class, classLoader);
        return (T)StreamSupport.stream(loader.spliterator(), false).filter(providerClass::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("Provider not found: " + providerClass));
    }

    public <T> T load(@NotNull Class<T> clazz, @NotNull File file, boolean saveDefault) throws IOException {
        if (!clazz.isAnnotationPresent(Config.class)) {
            throw new IllegalArgumentException("Class not annotated with @Config");
        }
        T config = null;
        if (file.exists()) {
            config = this.load(clazz, file);
        }
        if (config == null) {
            try {
                config = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("No default constructor in class");
            }
            if (saveDefault) {
                this.save(config, file);
            }
        }
        return config;
    }

    public <T> T load(Class<?> clazz, @NotNull File file, @NotNull Object defaultConfiguration) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, defaultConfiguration);
            return (T)object;
        }
    }

    public <T> T load(@NotNull Class<?> clazz, @NotNull File file, @NotNull InputStream defaultConfiguration) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, defaultConfiguration);
            return (T)object;
        }
    }

    public <T> T load(@NotNull Class<?> clazz, @NotNull InputStream is) throws IOException {
        try {
            return (T)this.load(clazz, is, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to initialize configuration class", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(@NotNull Class<?> clazz, @NotNull File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            return (T)object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to initialize configuration class", e);
        }
    }

    @Deprecated
    public <T> void save(@NotNull Class<T> targetClass, @NotNull T configuration, @NotNull File file) throws IOException {
        this.save(configuration, file);
    }

    public <T> void save(@NotNull T configuration, @NotNull File file) throws IOException {
        HashCode newHash;
        HashCode existingHash;
        Class<?> targetClass = configuration.getClass();
        if (!targetClass.isAnnotationPresent(Config.class)) {
            throw new IllegalArgumentException("Class not annotated with @Config");
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(configuration, outputStream);
        if (file.exists() && (existingHash = com.google.common.io.Files.asByteSource((File)file).hash(Hashing.sha256())).equals((Object)(newHash = Hashing.sha256().hashBytes(outputStream.toByteArray())))) {
            return;
        }
        Files.write(file.toPath(), outputStream.toByteArray(), new OpenOption[0]);
    }

    protected abstract Object load(@NotNull Class<?> var1, @NotNull InputStream var2, @NotNull Object var3) throws IOException;

    protected abstract Object load(@NotNull Class<?> var1, @NotNull InputStream var2, @NotNull InputStream var3) throws IOException;

    public abstract Object serialize(@NotNull Object var1);

    public abstract void deserialize(@NotNull Object var1, @NotNull Object var2);

    @Deprecated
    public <T> void save(@NotNull Class<T> targetClass, @NotNull T configuration, @NotNull OutputStream outputStream) throws IOException {
        this.save(configuration, outputStream);
    }

    public abstract <T> void save(@NotNull T var1, @NotNull OutputStream var2) throws IOException;
}

