/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.entry;

import lombok.Generated;
import su.plo.config.entry.ConfigEntry;

public final class DoubleConfigEntry
extends ConfigEntry<Double> {
    private double min;
    private double max;

    public DoubleConfigEntry(double defaultValue, double min, double max) {
        super(defaultValue);
        this.min = min;
        this.max = max;
    }

    @Override
    public void set(Double value) {
        if (this.min != this.max) {
            super.set(Math.max(Math.min(value, this.max), this.min));
        } else {
            super.set(value);
        }
    }

    public void setDefault(double value, double min, double max) {
        super.setDefault(value);
        this.min = min;
        this.max = max;
    }

    @Generated
    public double getMin() {
        return this.min;
    }

    @Generated
    public double getMax() {
        return this.max;
    }
}

