/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.createores.Config;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.util.ThreeState;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;

public class VeinRecipe
implements Recipe<CraftingInput> {
    public int priority;
    public Component veinName;
    public TagKey<Biome> biomeWhitelist;
    public TagKey<Biome> biomeBlacklist;
    public ThreeState finite;
    public float amountMultiplierMin;
    public float amountMultiplierMax;
    public RandomSpreadStructurePlacement placement;
    public ItemStack icon;
    protected boolean isNet;

    public VeinRecipe() {
    }

    public VeinRecipe(Component veinName, int priority, Optional<TagKey<Biome>> biomeWhitelist, Optional<TagKey<Biome>> biomeBlacklist, ThreeState finite, float amountMultiplierMin, float amountMultiplierMax, RandomSpreadStructurePlacement placement, ItemStack icon) {
        this.veinName = veinName;
        this.priority = priority;
        this.biomeWhitelist = biomeWhitelist.orElse(null);
        this.biomeBlacklist = biomeBlacklist.orElse(null);
        this.finite = finite;
        this.amountMultiplierMin = amountMultiplierMin;
        this.amountMultiplierMax = amountMultiplierMax;
        this.placement = placement;
        this.icon = icon;
    }

    public boolean matches(CraftingInput pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(CraftingInput p_44001_, HolderLookup.Provider p_267165_) {
        return this.getResultItem(p_267165_);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_267052_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return CreateOreExcavation.VEIN_RECIPES.getSerializer();
    }

    public RecipeType<?> getType() {
        return CreateOreExcavation.VEIN_RECIPES.getRecipeType();
    }

    public Component getName() {
        return this.veinName;
    }

    public String getGroup() {
        return "ore_vein_type";
    }

    public boolean canGenerate(ServerLevel lvl, Holder<Biome> b) {
        if (this.biomeBlacklist != null && VeinRecipe.isInTag(this.biomeBlacklist, lvl, b)) {
            return false;
        }
        if (this.biomeWhitelist != null) {
            return VeinRecipe.isInTag(this.biomeWhitelist, lvl, b);
        }
        return true;
    }

    private static boolean isInTag(TagKey<Biome> tag, ServerLevel lvl, Holder<Biome> b) {
        return lvl.getServer().registryAccess().registryOrThrow(Registries.BIOME).getTag(tag).map(t -> t.contains(b)).orElse(false);
    }

    public ThreeState isFinite() {
        return this.finite;
    }

    public float getMinAmount() {
        return this.amountMultiplierMin;
    }

    public float getMaxAmount() {
        return this.amountMultiplierMax;
    }

    public boolean isInfiniteClient() {
        return this.isNet ? this.finite == ThreeState.NEVER : (this.finite == ThreeState.DEFAULT ? Config.defaultInfinite : this.finite == ThreeState.NEVER);
    }

    public long getMinAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMin : (double)this.amountMultiplierMin * (double)Config.finiteAmountBase);
    }

    public long getMaxAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMax : (double)this.amountMultiplierMax * (double)Config.finiteAmountBase);
    }

    public int getNegGenerationPriority() {
        return -this.priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public RandomSpreadStructurePlacement getPlacement() {
        return this.placement;
    }

    public Optional<TagKey<Biome>> biomeWhitelist() {
        return Optional.ofNullable(this.biomeWhitelist);
    }

    public Optional<TagKey<Biome>> biomeBlacklist() {
        return Optional.ofNullable(this.biomeBlacklist);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends VeinRecipe> {
        public T create(ResourceLocation var1, RecipeType<?> var2, RecipeSerializer<?> var3);
    }

    public static class Serializer
    implements RecipeSerializer<VeinRecipe> {
        private static final ResourceLocation NULL = ResourceLocation.tryParse((String)"coe:null");
        public static final MapCodec<VeinRecipe> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ComponentSerialization.FLAT_CODEC.fieldOf("name").forGetter(VeinRecipe::getName), (App)Codec.INT.fieldOf("priority").forGetter(VeinRecipe::getPriority), (App)TagKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biomeWhitelist").forGetter(VeinRecipe::biomeWhitelist), (App)TagKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biomeBlacklist").forGetter(VeinRecipe::biomeBlacklist), (App)ThreeState.CODEC.fieldOf("finite").forGetter(VeinRecipe::isFinite), (App)Codec.FLOAT.fieldOf("amountMultiplierMin").forGetter(VeinRecipe::getMinAmount), (App)Codec.FLOAT.fieldOf("amountMultiplierMax").forGetter(VeinRecipe::getMaxAmount), (App)RandomSpreadStructurePlacement.CODEC.fieldOf("placement").forGetter(VeinRecipe::getPlacement), (App)ItemStack.CODEC.fieldOf("icon").forGetter(VeinRecipe::getIcon)).apply((Applicative)b, VeinRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, VeinRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static VeinRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            VeinRecipe r = new VeinRecipe();
            r.priority = buffer.readVarInt();
            r.veinName = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
            r.biomeWhitelist = Serializer.create((FriendlyByteBuf)buffer);
            r.biomeBlacklist = Serializer.create((FriendlyByteBuf)buffer);
            r.finite = buffer.readBoolean() ? ThreeState.ALWAYS : ThreeState.NEVER;
            r.amountMultiplierMin = buffer.readFloat();
            r.amountMultiplierMax = buffer.readFloat();
            r.icon = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            r.isNet = true;
            r.placement = new RandomSpreadStructurePlacement(2, 1, RandomSpreadType.LINEAR, 0);
            return r;
        }

        private static TagKey<Biome> create(FriendlyByteBuf buffer) {
            ResourceLocation rl = buffer.readResourceLocation();
            if (NULL.equals((Object)rl)) {
                return null;
            }
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, VeinRecipe recipe) {
            buffer.writeVarInt(recipe.priority);
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)recipe.veinName);
            Serializer.write(recipe.biomeWhitelist, (FriendlyByteBuf)buffer);
            Serializer.write(recipe.biomeBlacklist, (FriendlyByteBuf)buffer);
            buffer.writeBoolean(recipe.finite == ThreeState.DEFAULT ? !Config.defaultInfinite : recipe.finite == ThreeState.ALWAYS);
            buffer.writeFloat(recipe.amountMultiplierMin * (float)Config.finiteAmountBase);
            buffer.writeFloat(recipe.amountMultiplierMax * (float)Config.finiteAmountBase);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.icon);
        }

        private static void write(TagKey<Biome> tag, FriendlyByteBuf buffer) {
            buffer.writeResourceLocation(tag != null ? tag.location() : NULL);
        }

        public MapCodec<VeinRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, VeinRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

