/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.RandomSpreadGenerator;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.client.ClientCommandSourceStack;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class COECommand {
    private static final DynamicCommandExceptionType ERROR_VEIN_NOT_FOUND = new DynamicCommandExceptionType(p_214514_ -> Component.translatable((String)"command.coe.locate.failed", (Object[])new Object[]{p_214514_}));
    public static final SuggestionProvider<CommandSourceStack> ALL_RECIPES = SuggestionProviders.register((ResourceLocation)ResourceLocation.tryBuild((String)"createoreexcavation", (String)"all_recipes"), (ctx, builder) -> {
        RecipeManager rm;
        if (ctx.getSource() instanceof ClientCommandSourceStack || ctx.getSource() instanceof ClientSuggestionProvider) {
            rm = Minecraft.getInstance().getConnection().getRecipeManager();
        } else {
            Object patt0$temp = ctx.getSource();
            if (patt0$temp instanceof CommandSourceStack) {
                CommandSourceStack css = (CommandSourceStack)patt0$temp;
                rm = css.getServer().getRecipeManager();
            } else {
                rm = null;
            }
        }
        Stream<Object> rl = rm != null ? rm.getAllRecipesFor(CreateOreExcavation.VEIN_RECIPES.getRecipeType()).stream().map(RecipeHolder::id) : Stream.empty();
        return SharedSuggestionProvider.suggestResource(rl, (SuggestionsBuilder)builder);
    });

    public static void init() {
    }

    public static void register(RegisterCommandsEvent evt) {
        LiteralArgumentBuilder l = Commands.literal((String)"coe");
        l.then(((LiteralArgumentBuilder)Commands.literal((String)"setvein").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"recipe", (ArgumentType)ResourceLocationArgument.id()).suggests(ALL_RECIPES).executes(c -> {
            BlockPos p = BlockPosArgument.getLoadedBlockPos((CommandContext)c, (String)"pos");
            RecipeHolder rl = ResourceLocationArgument.getRecipe((CommandContext)c, (String)"recipe");
            if (rl.value() instanceof VeinRecipe) {
                COECommand.setVein((CommandSourceStack)c.getSource(), p, rl.id(), 0.8f);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"command.coe.setvein.success", (Object[])new Object[]{rl.id().toString()}), true);
                return 1;
            }
            return 0;
        })).then(Commands.argument((String)"multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).executes(c -> {
            float mul = FloatArgumentType.getFloat((CommandContext)c, (String)"multiplier");
            BlockPos p = BlockPosArgument.getLoadedBlockPos((CommandContext)c, (String)"pos");
            RecipeHolder rl = ResourceLocationArgument.getRecipe((CommandContext)c, (String)"recipe");
            if (rl.value() instanceof VeinRecipe) {
                COECommand.setVein((CommandSourceStack)c.getSource(), p, rl.id(), mul);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"command.coe.setvein.success", (Object[])new Object[]{rl.id().toString()}), true);
                return 1;
            }
            return 0;
        })))));
        l.then(((LiteralArgumentBuilder)Commands.literal((String)"removevein").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> {
            BlockPos p = BlockPosArgument.getLoadedBlockPos((CommandContext)c, (String)"pos");
            COECommand.setVein((CommandSourceStack)c.getSource(), p, null, 0.0f);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"command.coe.setvein.success", (Object[])new Object[]{Component.translatable((String)"chat.coe.veinFinder.nothing")}), true);
            return 1;
        })));
        l.then(((LiteralArgumentBuilder)Commands.literal((String)"locate").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"recipe", (ArgumentType)ResourceLocationArgument.id()).suggests(ALL_RECIPES).executes(c -> {
            RecipeHolder rl = ResourceLocationArgument.getRecipe((CommandContext)c, (String)"recipe");
            if (rl.value() instanceof VeinRecipe) {
                BlockPos blockpos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
                Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
                BlockPos at = OreVeinGenerator.getPicker(((CommandSourceStack)c.getSource()).getLevel()).locate(rl.id(), blockpos, ((CommandSourceStack)c.getSource()).getLevel(), 100);
                stopwatch.stop();
                if (at != null) {
                    int i = Mth.floor((float)RandomSpreadGenerator.distance2d(at, blockpos));
                    MutableComponent component = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{at.getX(), "~", at.getZ()})).withStyle(tc -> tc.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + at.getX() + " ~ " + at.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> COECommand.lambda$register$11(rl, (Component)component, i), false);
                    CreateOreExcavation.LOGGER.info("Locating element " + String.valueOf(rl.id()) + " took " + stopwatch.elapsed().toMillis() + " ms");
                    return i;
                }
                throw ERROR_VEIN_NOT_FOUND.create((Object)rl.id().toString());
            }
            throw ERROR_VEIN_NOT_FOUND.create((Object)rl.id().toString());
        })));
        evt.getDispatcher().register(l);
    }

    private static void setVein(CommandSourceStack css, BlockPos pos, ResourceLocation rl, float mul) {
        ChunkPos p = new ChunkPos(pos);
        LevelChunk chunk = css.getLevel().getChunk(p.x, p.z);
        OreData data = OreDataAttachment.getData(chunk);
        data.setRecipe(rl);
        data.setLoaded(true);
        data.setRandomMul(mul);
        data.setExtractedAmount(0L);
        chunk.setUnsaved(true);
    }

    private static /* synthetic */ Component lambda$register$11(RecipeHolder rl, Component component, int i) {
        return Component.translatable((String)"command.coe.locate.success", (Object[])new Object[]{rl.id().toString(), component, i});
    }
}

