/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ClickableList;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class ManualScreen
extends Screen {
    private Minecraft mc = Minecraft.getInstance();
    private float scaleFactor = 1.0f;
    private int xSize = 186;
    private int ySize = 198;
    private int guiLeft;
    private int guiTop;
    private List<Button> pageButtons = new ArrayList<Button>();
    @Nonnull
    public Tree.AbstractNode<ResourceLocation, ManualEntry> currentNode;
    public Stack<ManualInstance.ManualLink> previousSelectedEntry = new Stack();
    public int page;
    public static ManualScreen lastActiveManual;
    ManualInstance manual;
    ResourceLocation texture;
    private double[] lastClick;
    private double[] lastDrag;
    private EditBox searchField;
    private ClickableList entryList;
    private ClickableList suggestionList;
    private final boolean setLastActive;

    public ManualScreen(ManualInstance manual, ResourceLocation texture) {
        this(manual, texture, true);
    }

    public ManualScreen(ManualInstance manual, ResourceLocation texture, boolean setLastActive) {
        super((Component)Component.literal((String)"manual"));
        this.manual = manual;
        this.currentNode = manual.getRoot();
        this.texture = texture;
        this.setLastActive = setLastActive;
    }

    public ManualEntry getCurrentPage() {
        return this.currentNode.getLeafData();
    }

    public void setCurrentNode(@Nonnull Tree.AbstractNode<ResourceLocation, ManualEntry> entry) {
        this.currentNode = entry;
        if (this.currentNode.isLeaf()) {
            this.manual.openEntry(this.currentNode.getLeafData());
        }
    }

    public ManualInstance getManual() {
        return this.manual;
    }

    public void init() {
        Window res = this.mc.getWindow();
        double oldGuiScale = res.calculateScale(((Integer)this.mc.options.guiScale().get()).intValue(), this.mc.isEnforceUnicode());
        int guiScaleInt = Math.min(this.manual.getGuiRescale(), this.getMinecraft().getWindow().calculateScale(0, true));
        double newGuiScale = res.calculateScale(guiScaleInt, true);
        if (guiScaleInt > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.getGuiScale();
            res.setGuiScale(newGuiScale);
            this.width = res.getGuiScaledWidth();
            this.height = res.getGuiScaledHeight();
            res.setGuiScale(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.manual.openManual();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        boolean textField = false;
        this.pageButtons.clear();
        if (this.currentNode.isLeaf()) {
            this.currentNode.getLeafData().addButtons(this, this.guiLeft + 32, this.guiTop + 28, this.page, this.pageButtons);
            for (Button b : this.pageButtons) {
                this.addRenderableWidget((GuiEventListener)b);
            }
        } else {
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> children = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            for (Tree.AbstractNode<ResourceLocation, ManualEntry> node : this.currentNode.getChildren()) {
                if (!this.manual.showNodeInList(node)) continue;
                children.add(node);
            }
            Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> openEntry = sel -> {
                if (sel != null) {
                    this.previousSelectedEntry.clear();
                    this.setCurrentNode((Tree.AbstractNode<ResourceLocation, ManualEntry>)sel);
                    this.fullInit();
                }
            };
            this.entryList = new ClickableList(this, this.guiLeft + 40, this.guiTop + 20, 100, 168, 1.0f, children, openEntry);
            this.addRenderableWidget((GuiEventListener)this.entryList);
            this.suggestionList = new ClickableList(this, this.guiLeft + 180, this.guiTop + 138, 100, 80, 1.0f, new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>(), openEntry);
            this.suggestionList.visible = false;
            this.addRenderableWidget((GuiEventListener)this.suggestionList);
            textField = true;
        }
        if (this.currentNode.getSuperNode() != null) {
            this.addRenderableWidget((GuiEventListener)new GuiButtonManualNavigation(this, this.guiLeft + 24, this.guiTop + 10, 10, 10, 0, btn -> {
                if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                    this.previousSelectedEntry.pop().changePage(this, false);
                } else if (this.currentNode.getSuperNode() != null) {
                    this.setCurrentNode(this.currentNode.getSuperNode());
                }
                this.page = 0;
                this.fullInit();
            }));
        }
        if (textField) {
            this.searchField = new EditBox(this.font, this.guiLeft + 166, this.guiTop + 78, 120, 12, (Component)Component.empty());
            this.searchField.setTextColor(-1);
            this.searchField.setTextColorUneditable(-1);
            this.searchField.setBordered(false);
            this.searchField.setMaxLength(17);
            this.searchField.setFocused(true);
            this.searchField.setCanLoseFocus(false);
        } else if (this.searchField != null) {
            this.searchField = null;
        }
        if (this.setLastActive) {
            lastActiveManual = this;
        }
    }

    public void fullInit() {
        super.init(this.minecraft, this.width, this.height);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float deltaTime) {
        PoseStack transform = graphics.pose();
        transform.pushPose();
        if (this.scaleFactor != 1.0f) {
            transform.scale(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        super.render(graphics, mouseX, mouseY, deltaTime);
        this.manual.entryRenderPre();
        if (this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            boolean b0 = (mouseX -= this.guiLeft) > 32 && mouseX < 49 && (mouseY -= this.guiTop) > 179 && mouseY < 189;
            boolean b1 = mouseX > 135 && mouseX < 152 && mouseY > 179 && mouseY < 189;
            RenderSystem.enableBlend();
            if (this.page > 0) {
                graphics.blit(this.texture, this.guiLeft + 32, this.guiTop + 179, 0, 216 + (b0 ? 20 : 0), 16, 10);
            }
            if (this.page < selectedEntry.getPageCount() - 1) {
                graphics.blit(this.texture, this.guiLeft + 136, this.guiTop + 179, 0, 226 + (b1 ? 20 : 0), 16, 10);
            }
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), String.valueOf(ChatFormatting.BOLD) + selectedEntry.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 14, this.manual.getTitleColour(), true);
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), this.manual.formatEntrySubtext(selectedEntry.getSubtext()), this.guiLeft + this.xSize / 2, this.guiTop + 22, this.manual.getSubTitleColour(), true);
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), ChatFormatting.BOLD.toString() + (this.page + 1), this.guiLeft + this.xSize / 2, this.guiTop + 183, this.manual.getPagenumberColour(), false);
            this.manual.titleRenderPost();
            selectedEntry.renderPage(graphics, this, this.guiLeft + 32, this.guiTop + 28, mouseX - 32, mouseY - 28);
            mouseX += this.guiLeft;
            mouseY += this.guiTop;
        } else {
            String title = ManualUtils.getTitleForNode(this.currentNode, this.manual);
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), String.valueOf(ChatFormatting.BOLD) + title, this.guiLeft + this.xSize / 2, this.guiTop + 12, this.manual.getTitleColour(), true);
            this.manual.titleRenderPost();
        }
        if (this.searchField != null) {
            this.searchField.render(graphics, mouseX, mouseY, deltaTime);
            if (this.suggestionList.visible) {
                graphics.drawString(this.manual.fontRenderer(), "It looks like you meant:", this.guiLeft + 180, this.guiTop + 128, this.manual.getTextColour());
            }
        }
        for (Button btn : this.pageButtons) {
            btn.render(graphics, mouseX, mouseY, deltaTime);
        }
        RenderSystem.enableBlend();
        this.manual.entryRenderPost();
        transform.popPose();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float deltaTime) {
        graphics.blit(this.texture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchField != null) {
            int l = this.searchField.getValue().length() * 6;
            if (l > 20) {
                graphics.blit(this.texture, this.guiLeft + 166, this.guiTop + 74, 136 + (120 - l), 238, l, 18);
            }
            if (this.suggestionList.visible) {
                graphics.blit(this.texture, this.guiLeft + 174, this.guiTop + 100, 214, 212, 16, 26);
                int h = this.suggestionList.getHeight();
                int w = 76;
                graphics.blit(this.texture, this.guiLeft + 174, this.guiTop + 116, 230, 212, 16, 16);
                graphics.blit(this.texture, this.guiLeft + 174, this.guiTop + 132 + h, 230, 228, 16, 10);
                graphics.blit(this.texture, this.guiLeft + 190 + w, this.guiTop + 116, 246, 212, 10, 16);
                graphics.blit(this.texture, this.guiLeft + 190 + w, this.guiTop + 132 + h, 246, 228, 10, 10);
                for (int hh = 0; hh < h; ++hh) {
                    graphics.blit(this.texture, this.guiLeft + 174, this.guiTop + 132 + hh, 230, 228, 16, 1);
                    for (int ww = 0; ww < w; ++ww) {
                        graphics.blit(this.texture, this.guiLeft + 190 + ww, this.guiTop + 132 + hh, 246, 228, 1, 1);
                    }
                    graphics.blit(this.texture, this.guiLeft + 190 + w, this.guiTop + 132 + hh, 246, 228, 10, 1);
                }
                for (int ww = 0; ww < w; ++ww) {
                    graphics.blit(this.texture, this.guiLeft + 190 + ww, this.guiTop + 116, 246, 212, 1, 16);
                    graphics.blit(this.texture, this.guiLeft + 190 + ww, this.guiTop + 132 + h, 246, 228, 1, 10);
                }
            }
        }
    }

    public void removed() {
        this.manual.closeManual();
        super.removed();
    }

    private void drawCenteredStringScaled(GuiGraphics graphics, Font fr, String s, int x, int y, int colour, boolean shadow) {
        int xx = (int)Math.floor((double)x - (double)fr.width(s) / 2.0);
        double d = y;
        Objects.requireNonNull(fr);
        int yy = (int)Math.floor(d - 9.0 / 2.0);
        graphics.drawString(fr, s, xx, yy, colour, shadow);
    }

    @SubscribeEvent
    public static void appendLinkToTooltip(ItemTooltipEvent ev) {
        ManualInstance.ManualLink link;
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof ManualScreen)) {
            return;
        }
        ManualScreen manualScreen = (ManualScreen)screen;
        if (!manualScreen.currentNode.isLeaf()) {
            return;
        }
        ItemStack stack = ev.getItemStack();
        if (manualScreen.currentNode.getLeafData().getHighlightedStack(manualScreen.page) == stack && (link = manualScreen.manual.getManualLink(stack)) != null) {
            ev.getToolTip().add(Component.literal((String)manualScreen.manual.formatLink(link)));
        }
    }

    public boolean mouseScrolled(double x, double y, double wheelX, double wheelY) {
        super.mouseScrolled(x, y, wheelX, wheelY);
        if (wheelY != 0.0 && this.currentNode.isLeaf()) {
            if (wheelY > 0.0 && this.page > 0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (wheelY < 0.0 && this.page < this.currentNode.getLeafData().getPageCount() - 1) {
                ++this.page;
                this.fullInit();
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (button == 0 && this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            double mxRelative = mx - (double)this.guiLeft;
            double myRelative = my - (double)this.guiTop;
            if (this.page > 0 && mxRelative > 32.0 && mxRelative < 49.0 && myRelative > 179.0 && myRelative < 189.0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (this.page < selectedEntry.getPageCount() - 1 && mxRelative > 135.0 && mxRelative < 152.0 && myRelative > 179.0 && myRelative < 189.0) {
                ++this.page;
                this.fullInit();
                return true;
            }
            ItemStack highlighted = selectedEntry.getHighlightedStack(this.page);
            if (!highlighted.isEmpty()) {
                ManualInstance.ManualLink link = this.getManual().getManualLink(highlighted);
                if (link != null) {
                    link.changePage(this, true);
                }
                return true;
            }
        } else if (button == 1) {
            if (this.searchField != null && !this.searchField.getValue().isEmpty()) {
                this.searchField.setValue("");
            } else if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                this.previousSelectedEntry.pop().changePage(this, false);
            } else if (this.currentNode.getSuperNode() != null) {
                this.setCurrentNode(this.currentNode.getSuperNode());
                this.page = 0;
            }
            this.fullInit();
            return true;
        }
        this.lastClick = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
        if (super.mouseClicked(mx, my, button)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.mouseClicked(mx, my, button);
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int action) {
        this.lastClick = null;
        this.lastDrag = null;
        return super.mouseReleased(mx, my, action);
    }

    public boolean mouseDragged(double mx, double my, int button, double deltaX, double deltaY) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (this.lastClick != null && this.currentNode.isLeaf()) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            }
            this.currentNode.getLeafData().mouseDragged(this, this.guiLeft + 32, this.guiTop + 28, this.lastClick[0], this.lastClick[1], mx - (double)this.guiLeft, my - (double)this.guiTop, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            return true;
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField != null && this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchField != null && this.searchField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateSearch() {
        String search = this.searchField.getValue();
        if (search.trim().isEmpty()) {
            this.suggestionList.visible = false;
            this.fullInit();
        } else {
            search = search.toLowerCase(Locale.ENGLISH);
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> lHeaders = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            HashSet lSpellcheck = new HashSet();
            String searchFinal = search;
            this.manual.getAllEntriesAndCategories().forEach(node -> {
                if (this.manual.showNodeInList((Tree.AbstractNode<ResourceLocation, ManualEntry>)node)) {
                    String title = ManualUtils.getTitleForNode(node, this.manual).toLowerCase(Locale.ENGLISH);
                    if (title.contains(searchFinal)) {
                        lHeaders.add((Tree.AbstractNode<ResourceLocation, ManualEntry>)node);
                    } else {
                        lSpellcheck.add(node);
                    }
                }
            });
            List<Tree.AbstractNode<ResourceLocation, ManualEntry>> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck, 4, e -> ManualUtils.getTitleForNode(e, this.manual));
            for (Tree.AbstractNode node2 : lSpellcheck) {
                if (lCorrections.contains(node2) || !node2.isLeaf() || !((ManualEntry)node2.getLeafData()).listForSearch(search)) continue;
                lHeaders.add(node2);
                lCorrections.add(node2);
                break;
            }
            this.entryList.setEntries(lHeaders);
            if (!lCorrections.isEmpty()) {
                this.suggestionList.setEntries(lCorrections);
            }
            this.suggestionList.visible = !lCorrections.isEmpty();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

