/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BulletItem<T>
extends IEBaseItem
implements IEItemInterfaces.IColouredItem {
    private final BulletHandler.IBullet<T> type;
    private final DataComponentType<T> component;

    public BulletItem(BulletHandler.IBullet<T> type) {
        super(new Item.Properties().component(IEDataComponents.getBulletData(type), type.getCodec().defaultValue()));
        this.type = type;
        this.component = IEDataComponents.getBulletData(type);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        this.type.addTooltip(stack.get(this.component), ctx, list, flag);
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.type.getColour(stack.get(this.component), pass).toInt();
    }

    public BulletHandler.IBullet<?> getType() {
        return this.type;
    }

    public Entity createBullet(Level world, @Nullable Player shooter, Vec3 startPosition, Vec3 vecDir, ItemStack bulletStack, boolean electro) {
        Object data = bulletStack.get(IEDataComponents.getBulletData(this.type));
        RevolvershotEntity bullet = new RevolvershotEntity(world, startPosition.x + vecDir.x, startPosition.y + vecDir.y, startPosition.z + vecDir.z, vecDir.x, vecDir.y, vecDir.z, this.type, data);
        bullet.bulletElectro = electro;
        bullet.setOwner((Entity)shooter);
        return this.type.getProjectile(shooter, data, (Entity)bullet, false);
    }
}

