/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public interface IConveyorModelRender<T extends IConveyorBelt> {
    default public Object getModelCacheKey(RenderContext<T> context) {
        return IConveyorModelRender.getDefaultData(this, context);
    }

    public static <T extends IConveyorBelt> BasicConveyorCacheData getDefaultData(IConveyorModelRender<T> renderer, RenderContext<T> context) {
        T instance = context.instance();
        Block cover = context.getCover();
        if (instance == null) {
            return new BasicConveyorCacheData(cover, Direction.NORTH, ConveyorHandler.ConveyorDirection.HORIZONTAL, true, true, true, DyeColor.WHITE);
        }
        Direction facing = instance.getFacing();
        return new BasicConveyorCacheData(cover, facing, instance.getConveyorDirection(), instance.isActive(), renderer.shouldRenderWall(facing, ConveyorWall.LEFT, context), renderer.shouldRenderWall(facing, ConveyorWall.RIGHT, context), instance.getDyeColour());
    }

    default public Transformation modifyBaseRotationMatrix(Transformation matrix) {
        return matrix;
    }

    public ResourceLocation getActiveTexture();

    public ResourceLocation getInactiveTexture();

    default public ResourceLocation getColouredStripesTexture() {
        return ConveyorHandler.textureConveyorColour;
    }

    public List<BakedQuad> modifyQuads(List<BakedQuad> var1, RenderContext<T> var2, @Nullable RenderType var3);

    default public boolean shouldRenderWall(Direction facing, ConveyorWall wall, RenderContext<T> context) {
        T instance = context.instance();
        if (instance == null || instance.getConveyorDirection() != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            return true;
        }
        Direction side = wall.getWallSide(facing);
        BlockPos pos = instance.getBlockEntity().getBlockPos().relative(side);
        return ConveyorHandler.connectsToConveyor(instance.getBlockEntity().getLevel(), pos, side);
    }

    default public void updateCachedModels(ModelBaker baker, Function<Material, TextureAtlasSprite> getTexture) {
    }

    public record RenderContext<T extends IConveyorBelt>(IConveyorType<T> type, @Nullable T instance, Block coverFallback) {
        public Block getCover() {
            return IConveyorBelt.getCoverOrDefault(this.instance, this.coverFallback);
        }

        public Direction getFacing() {
            return this.instance == null ? Direction.NORTH : this.instance.getFacing();
        }

        public ConveyorHandler.ConveyorDirection getConveyorDirection() {
            return this.instance == null ? ConveyorHandler.ConveyorDirection.HORIZONTAL : this.instance.getConveyorDirection();
        }

        public boolean isActiveOr(boolean fallback) {
            return this.instance == null ? fallback : this.instance.isActive();
        }
    }
}

