/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.inventory;

import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import com.talhanation.smallships.world.inventory.neoforge.ModMenuTypesImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class ModMenuTypes {
    public static final MenuType<ShipContainerMenu> SHIP_CONTAINER = ModMenuTypes.getMenuType("ship_container");

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends AbstractContainerMenu> MenuType<T> getMenuType(String id) {
        return ModMenuTypesImpl.getMenuType(id);
    }

    @Nullable
    public static ShipContainerMenu extendedShipContainerMenuTypeSupplier(int syncId, Inventory inventory, UUID shipUUID) {
        ContainerShip containerShip = inventory.player.level().getEntitiesOfClass(ContainerShip.class, inventory.player.getBoundingBoxForCulling().inflate(16.0), ship -> ship.getUUID().equals(shipUUID)).stream().filter(Entity::isAlive).findAny().orElse(null);
        if (containerShip == null) {
            return null;
        }
        if (containerShip.getContainerSize() != containerShip.getItemStacks().size()) {
            containerShip.resizeContainer(containerShip.getContainerSize());
        }
        return new ShipContainerMenu(SHIP_CONTAINER, syncId, inventory, containerShip);
    }
}

