/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.talhanation.smallships.client.model.CannonModel;
import com.talhanation.smallships.world.entity.cannon.Cannon;
import com.talhanation.smallships.world.entity.cannon.GroundCannonEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class GroundCannonRenderer
extends EntityRenderer<GroundCannonEntity> {
    private final CannonModel model = new CannonModel();

    public GroundCannonRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(GroundCannonEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)"textures/entity/cannon/ship_cannon.png");
    }

    public void render(GroundCannonEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        ResourceLocation resourceLocation = this.getTextureLocation(entity);
        poseStack.pushPose();
        poseStack.scale(-1.3f, -1.3f, 1.3f);
        Cannon cannon = entity.getCannon();
        float lerpYaw = -(cannon.getPrevYaw() + (cannon.getYaw() - cannon.getPrevYaw()) * partialTicks);
        poseStack.mulPose(Axis.YP.rotationDegrees(lerpYaw));
        this.renderCannonModel(cannon, partialTicks, resourceLocation, poseStack, multiBufferSource, packedLight);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    public void renderCannonModel(Cannon cannon, float partialTicks, ResourceLocation texture, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        poseStack.scale(0.6f, 0.6f, 0.6f);
        poseStack.translate(0.0, -1.5, 0.0);
        float pitch = cannon.getPrevPitch() + partialTicks * (cannon.getPitch() - cannon.getPrevPitch());
        this.model.setLaufPitch(pitch);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)texture));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

