/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import jeresources.compatibility.CompatBase;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class MobTableBuilder {
    private final Map<ResourceKey<LootTable>, Supplier<LivingEntity>> mobTables = new HashMap<ResourceKey<LootTable>, Supplier<LivingEntity>>();
    private final Level level = CompatBase.getLevel();

    public void add(ResourceKey<LootTable> resourceLocation, EntityType<?> entityType) {
        if (MobTableBuilder.isNonLiving(entityType) || !entityType.isEnabled(this.level.enabledFeatures())) {
            return;
        }
        this.mobTables.put(resourceLocation, () -> (LivingEntity)entityType.create(this.level));
    }

    public void addSheep(ResourceKey<LootTable> resourceLocation, EntityType<Sheep> entityType, DyeColor dye) {
        this.mobTables.put(resourceLocation, () -> {
            Sheep sheep = (Sheep)entityType.create(this.level);
            assert (sheep != null);
            sheep.setColor(dye);
            return sheep;
        });
    }

    public Map<ResourceKey<LootTable>, Supplier<LivingEntity>> getMobTables() {
        return this.mobTables;
    }

    private static boolean isNonLiving(@NotNull EntityType<?> entityType) {
        return !EntityLootSubProvider.SPECIAL_LOOT_TABLE_TYPES.contains(entityType) && entityType.getCategory() == MobCategory.MISC;
    }
}

