/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.data.EntityData;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public abstract class DrillRecipe<I>
implements Recipe<CraftingInput> {
    public static ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");
    public I output;
    public List<LaserDrillRarity> rarity;
    public int pointer = 0;
    public Ingredient catalyst;
    public Optional<EntityData> entityData;

    public DrillRecipe(I output, Ingredient catalyst, Optional<EntityData> data, List<LaserDrillRarity> rarity) {
        this.output = output;
        this.rarity = rarity;
        this.catalyst = catalyst;
        this.entityData = data;
    }

    public DrillRecipe(I output, Ingredient catalyst, Optional<EntityData> data, LaserDrillRarity ... rarity) {
        this(output, catalyst, data, Arrays.asList(rarity));
    }

    public DrillRecipe(I output, int color, Optional<EntityData> data, LaserDrillRarity ... rarity) {
        this(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), data, rarity);
    }

    public DrillRecipe(I output, int color, LaserDrillRarity ... rarity) {
        this(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), Optional.empty(), rarity);
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, String modIdCondition, DrillRecipe<?> recipe) {
        ResourceLocation rl = DrillRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, recipe, advancementHolder, new ICondition[]{new ModLoadedCondition(modIdCondition)});
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("laser_drill_fluid/" + key));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public abstract RecipeSerializer<?> getSerializer();

    public abstract RecipeType<?> getType();
}

