/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.FrameworkNetworkBuilder;
import com.mrcrayfish.framework.api.network.FrameworkResponse;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import com.mrcrayfish.framework.network.message.FrameworkMessage;
import com.mrcrayfish.framework.network.message.FrameworkPayload;
import com.mrcrayfish.framework.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.configuration.Acknowledge;
import com.mrcrayfish.framework.platform.network.NeoForgeConfigurationTask;
import com.mrcrayfish.framework.platform.network.NeoForgeMessageContext;
import com.mrcrayfish.framework.platform.network.NeoForgeNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class NeoForgeNetworkBuilder
implements FrameworkNetworkBuilder {
    private final ResourceLocation id;
    private final int version;
    private boolean optional = false;
    private final List<FrameworkMessage<?, RegistryFriendlyByteBuf>> playMessages = new ArrayList();
    private final List<BiConsumer<NeoForgeNetwork, PayloadRegistrar>> playPayloads = new ArrayList<BiConsumer<NeoForgeNetwork, PayloadRegistrar>>();
    private final List<FrameworkMessage<?, FriendlyByteBuf>> configurationMessages = new ArrayList();
    private final List<BiConsumer<NeoForgeNetwork, PayloadRegistrar>> configurationPayloads = new ArrayList<BiConsumer<NeoForgeNetwork, PayloadRegistrar>>();
    private final List<BiFunction<NeoForgeNetwork, ServerConfigurationPacketListener, ICustomConfigurationTask>> configurationTasks = new ArrayList<BiFunction<NeoForgeNetwork, ServerConfigurationPacketListener, ICustomConfigurationTask>>();

    public NeoForgeNetworkBuilder(ResourceLocation id, int version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public NeoForgeNetworkBuilder optional() {
        this.optional = true;
        return this;
    }

    @Override
    public <T> FrameworkNetworkBuilder registerPlayMessage(String name, Class<T> messageClass, StreamCodec<RegistryFriendlyByteBuf, T> codec, BiConsumer<T, MessageContext> handler) {
        return this.registerPlayMessage(name, messageClass, codec, handler, null);
    }

    @Override
    public <T> FrameworkNetworkBuilder registerPlayMessage(String name, Class<T> messageClass, StreamCodec<RegistryFriendlyByteBuf, T> codec, BiConsumer<T, MessageContext> handler, @Nullable PacketFlow flow) {
        ResourceLocation payloadId = FrameworkNetworkBuilder.createMessageId(this.id, name);
        CustomPacketPayload.Type payloadType = new CustomPacketPayload.Type(payloadId);
        StreamCodec<RegistryFriendlyByteBuf, FrameworkPayload<T>> payloadCodec = FrameworkPayload.codec(payloadType, codec);
        PlayMessage message = new PlayMessage(payloadType, messageClass, payloadCodec, handler, flow);
        this.playMessages.add(message);
        this.playPayloads.add((network, registrar) -> this.getPlayFunction((PayloadRegistrar)registrar, message.flow()).apply(message.type(), message.codec(), (payload, ctx) -> {
            NeoForgeMessageContext context = new NeoForgeMessageContext(ctx, ctx.flow(), ctx.player());
            message.handler().accept(payload.msg(), context);
            context.getReply().ifPresent(msg -> ctx.reply(network.encode(msg)));
        }));
        return this;
    }

    @Override
    public <T> FrameworkNetworkBuilder registerConfigurationMessage(String name, Class<T> taskClass, StreamCodec<FriendlyByteBuf, T> codec, BiFunction<T, Consumer<Runnable>, FrameworkResponse> handler, Supplier<List<T>> messages) {
        return this.registerConfigurationMessage(name, taskClass, codec, handler, messages, PacketFlow.CLIENTBOUND);
    }

    @Override
    public <T> FrameworkNetworkBuilder registerConfigurationMessage(String name, Class<T> taskClass, StreamCodec<FriendlyByteBuf, T> codec, BiFunction<T, Consumer<Runnable>, FrameworkResponse> handler, Supplier<List<T>> messages, @Nullable PacketFlow flow) {
        this.registerConfigurationAckMessage();
        ResourceLocation payloadId = FrameworkNetworkBuilder.createMessageId(this.id, name);
        CustomPacketPayload.Type payloadType = new CustomPacketPayload.Type(payloadId);
        StreamCodec<FriendlyByteBuf, FrameworkPayload<T>> payloadCodec = FrameworkPayload.codec(payloadType, codec);
        ConfigurationMessage<T> message = new ConfigurationMessage<T>(payloadType, taskClass, payloadCodec, handler, flow);
        this.configurationMessages.add(message);
        this.configurationPayloads.add(this.createConfigurationPayloadConsumer(message));
        ConfigurationTask.Type taskType = new ConfigurationTask.Type(message.type().id().toString());
        this.configurationTasks.add((network, listener) -> new NeoForgeConfigurationTask((NeoForgeNetwork)network, (ServerConfigurationPacketListener)listener, taskType, messages));
        return this;
    }

    private void registerConfigurationAckMessage() {
        if (this.configurationMessages.isEmpty()) {
            ResourceLocation payloadId = FrameworkNetworkBuilder.createMessageId(this.id, "ack");
            CustomPacketPayload.Type payloadType = new CustomPacketPayload.Type(payloadId);
            StreamCodec<FriendlyByteBuf, FrameworkPayload<Acknowledge>> payloadCodec = FrameworkPayload.codec(payloadType, Acknowledge.STREAM_CODEC);
            FrameworkMessage<Acknowledge, FriendlyByteBuf> message = new FrameworkMessage<Acknowledge, FriendlyByteBuf>(payloadType, Acknowledge.class, payloadCodec, Acknowledge::handle, PacketFlow.SERVERBOUND);
            this.configurationMessages.add(message);
            this.configurationPayloads.add(this.createConfigurationPayloadConsumer(message));
        }
    }

    private <T> BiConsumer<NeoForgeNetwork, PayloadRegistrar> createConfigurationPayloadConsumer(FrameworkMessage<T, FriendlyByteBuf> message) {
        return (network, registrar) -> this.getConfigurationFunction((PayloadRegistrar)registrar, message.flow()).apply(message.type(), message.codec(), (payload, ctx) -> {
            NeoForgeMessageContext context = new NeoForgeMessageContext(ctx, ctx.flow(), null);
            message.handler().accept(payload.msg(), context);
            context.getReply().ifPresent(msg -> ctx.reply(network.encode(msg)));
        });
    }

    private <T extends CustomPacketPayload> TriFunction<CustomPacketPayload.Type<T>, StreamCodec<RegistryFriendlyByteBuf, T>, IPayloadHandler<T>, PayloadRegistrar> getPlayFunction(PayloadRegistrar registrar, @Nullable PacketFlow flow) {
        if (flow == PacketFlow.CLIENTBOUND) {
            return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToClient(arg_0, arg_1, arg_2);
        }
        if (flow == PacketFlow.SERVERBOUND) {
            return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToServer(arg_0, arg_1, arg_2);
        }
        return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playBidirectional(arg_0, arg_1, arg_2);
    }

    private <T extends CustomPacketPayload> TriFunction<CustomPacketPayload.Type<T>, StreamCodec<FriendlyByteBuf, T>, IPayloadHandler<T>, PayloadRegistrar> getConfigurationFunction(PayloadRegistrar registrar, @Nullable PacketFlow flow) {
        if (flow == PacketFlow.CLIENTBOUND) {
            return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).configurationToClient(arg_0, arg_1, arg_2);
        }
        if (flow == PacketFlow.SERVERBOUND) {
            return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).configurationToServer(arg_0, arg_1, arg_2);
        }
        return (arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).configurationBidirectional(arg_0, arg_1, arg_2);
    }

    @Override
    public FrameworkNetwork build() {
        return new NeoForgeNetwork(this.id, this.version, this.optional, this.playMessages, this.playPayloads, this.configurationMessages, this.configurationPayloads, this.configurationTasks);
    }
}

