/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.block.entity.BlockFilterAttachment;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventoryChangeTracker;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.IValidInfo;
import com.tom.storagemod.util.WorldStates;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;

public interface PlatformInventoryAccess
extends IInventoryAccess {
    public static final PlatformInventoryAccess EMPTY = new PlatformInventoryAccess(){

        @Override
        public IInventoryAccess.IInventoryChangeTracker tracker() {
            return InventoryChangeTracker.NULL;
        }

        @Override
        public IItemHandler get() {
            return EmptyItemHandler.INSTANCE;
        }

        @Override
        public ItemStack pullMatchingStack(ItemStack st, long max) {
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack pushStack(ItemStack stack) {
            return stack;
        }

        @Override
        public int getFreeSlotCount() {
            return 0;
        }

        @Override
        public IInventoryAccess getRootHandler(Set<IProxy> dejaVu) {
            return this;
        }
    };

    public IItemHandler get();

    @Override
    default public int getFreeSlotCount() {
        IItemHandler itemHandler = this.get();
        if (itemHandler == null) {
            return 0;
        }
        int empty = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).isEmpty()) continue;
            ++empty;
        }
        return empty;
    }

    @Override
    default public int getSlotCount() {
        IItemHandler itemHandler = this.get();
        if (itemHandler == null) {
            return 0;
        }
        return itemHandler.getSlots();
    }

    public static BlockFilter getBlockFilterAt(Level level, BlockPos p, boolean make) {
        BlockEntity be = level.getBlockEntity(p);
        if (be == null || !make && !be.hasData(Platform.BLOCK_FILTER)) {
            return null;
        }
        return ((BlockFilterAttachment)be.getData(Platform.BLOCK_FILTER)).getFilter();
    }

    public static void removeBlockFilterAt(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null || !be.hasData(Platform.BLOCK_FILTER)) {
            return;
        }
        BlockFilterAttachment f = (BlockFilterAttachment)be.getData(Platform.BLOCK_FILTER);
        f.getFilter().dropContents((LevelAccessor)level, pos);
        be.removeData(Platform.BLOCK_FILTER);
    }

    public static class BlockInventoryAccess
    implements PlatformInventoryAccess {
        private boolean valid;
        private BlockCapabilityCache<IItemHandler, Direction> itemCache;
        private IInventoryAccess.IInventoryChangeTracker.Delegate tracker = new IInventoryAccess.IInventoryChangeTracker.Delegate();

        public void onLoad(Level level, BlockPos worldPosition, Direction side, IValidInfo isValid) {
            this.valid = true;
            this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)level), (BlockPos)worldPosition, (Object)side, () -> this.valid && isValid.isObjectValid(), this::onInvalid);
        }

        protected void onInvalid() {
        }

        @Override
        public IInventoryAccess.IInventoryChangeTracker tracker() {
            IItemHandler itemHandler = (IItemHandler)this.itemCache.getCapability();
            if (itemHandler != null) {
                this.tracker.setDelegate(WorldStates.getTracker(itemHandler));
            } else {
                this.tracker.setDelegate(InventoryChangeTracker.NULL);
            }
            return this.tracker;
        }

        @Override
        public IItemHandler get() {
            return this.itemCache == null || !this.valid ? null : (IItemHandler)this.itemCache.getCapability();
        }

        public static boolean hasInventoryAt(Level level, BlockPos pos, BlockState state, Direction direction) {
            return level.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, null, (Object)direction) != null;
        }

        @Override
        public void markInvalid() {
            this.valid = false;
        }

        public boolean exists() {
            return this.itemCache.getCapability() != null;
        }

        @Override
        public IInventoryAccess getRootHandler(Set<IProxy> dejaVu) {
            IItemHandler iItemHandler = this.get();
            if (iItemHandler instanceof IProxy) {
                IProxy p = (IProxy)iItemHandler;
                if (dejaVu.add(p)) {
                    return p.getRootHandler(dejaVu);
                }
                return this;
            }
            return this;
        }

        public String toString() {
            return "BlockInventoryAccess at " + String.valueOf(this.itemCache.pos());
        }
    }
}

