/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class EventHandler<T> {
    private final Function<T[], T> invokerFactory;
    private final Object lock = new Object();
    private final Class<T> eventType;
    private List<T> handlers;
    private T invoker;

    public EventHandler(Class<T> eventType, Function<T[], T> invokerFactory) {
        this.invokerFactory = invokerFactory;
        this.eventType = eventType;
        this.handlers = new ArrayList<T>();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(T listener) {
        Objects.requireNonNull(listener, "Tried to register a null listener!");
        Object object = this.lock;
        synchronized (object) {
            this.handlers.add(listener);
            this.update();
        }
    }

    private void update() {
        this.invoker = this.invokerFactory.apply((T[][])this.handlers.toArray(i -> (Object[])Array.newInstance(this.eventType, i)));
    }

    public T invoker() {
        return this.invoker;
    }
}

