/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.event.ServerEvents;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.HandshakeServer;
import nl.enjarai.doabarrelroll.net.ServerConfigHolder;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigSyncS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateAckS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.RollSyncC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.RollSyncS2CPacket;

public class ServerNetworking {
    public static final ServerConfigHolder<ConfigUpdateAckS2CPacket> CONFIG_HOLDER = new ServerConfigHolder<ConfigUpdateAckS2CPacket>(FabricLoader.getInstance().getConfigDir().resolve("do_a_barrel_roll-server.json"), ModConfigServer.CODEC, ConfigUpdateAckS2CPacket::new, ServerEvents::updateServerConfig);
    public static final HandshakeServer<ConfigSyncS2CPacket> HANDSHAKE_SERVER = new HandshakeServer<ConfigSyncS2CPacket>(ConfigSyncS2CPacket::new, CONFIG_HOLDER, player -> !ModConfigServer.canModify(player));

    public static void init() {
        CONFIG_HOLDER.setHandshakeServer(HANDSHAKE_SERVER);
        PayloadTypeRegistry.playC2S().register(ConfigResponseC2SPacket.PACKET_ID, ConfigResponseC2SPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ConfigUpdateC2SPacket.PACKET_ID, ConfigUpdateC2SPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(RollSyncC2SPacket.PACKET_ID, RollSyncC2SPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigSyncS2CPacket.PACKET_ID, ConfigSyncS2CPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigUpdateAckS2CPacket.PACKET_ID, ConfigUpdateAckS2CPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(RollSyncS2CPacket.PACKET_ID, RollSyncS2CPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConfigResponseC2SPacket.PACKET_ID, (payload, context) -> {
            HandshakeServer.HandshakeState reply = HANDSHAKE_SERVER.clientReplied(context.player().connection, (ConfigResponseC2SPacket)payload);
            if (reply == HandshakeServer.HandshakeState.RESEND) {
                ServerNetworking.sendHandshake(context.player());
            } else if (reply == HandshakeServer.HandshakeState.ACCEPTED) {
                ServerPlayNetworking.registerReceiver((ServerGamePacketListenerImpl)context.player().connection, RollSyncC2SPacket.PACKET_ID, (payload1, context1) -> {
                    RollEntity rollPlayer = (RollEntity)context1.player();
                    boolean isRolling = payload1.rolling();
                    float roll = payload1.roll();
                    rollPlayer.doABarrelRoll$setRolling(isRolling);
                    rollPlayer.doABarrelRoll$setRoll(isRolling ? Mth.wrapDegrees((float)roll) : 0.0f);
                });
                ServerPlayNetworking.registerReceiver((ServerGamePacketListenerImpl)context.player().connection, ConfigUpdateC2SPacket.PACKET_ID, (payload1, context1) -> context1.responseSender().sendPacket((CustomPacketPayload)CONFIG_HOLDER.clientSendsUpdate(context1.player(), (ConfigUpdateC2SPacket)payload1)));
            }
        });
        ServerEvents.SERVER_CONFIG_UPDATE.register((server, config) -> {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                ServerNetworking.sendHandshake(player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> HANDSHAKE_SERVER.playerDisconnected(handler));
        ServerTickEvents.END_SERVER_TICK.register(HANDSHAKE_SERVER::tick);
    }

    public static void sendHandshake(ServerPlayer player) {
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)HANDSHAKE_SERVER.initiateConfigSync(player.connection));
        HANDSHAKE_SERVER.configSentToClient(player.connection);
    }

    public static void sendRollUpdates(Entity entity) {
        RollEntity rollEntity = (RollEntity)entity;
        boolean isRolling = rollEntity.doABarrelRoll$isRolling();
        float roll = rollEntity.doABarrelRoll$getRoll();
        RollSyncS2CPacket payload = new RollSyncS2CPacket(entity.getId(), isRolling, roll);
        PlayerLookup.tracking((Entity)entity).stream().filter(player -> player != entity).filter(player -> ServerNetworking.HANDSHAKE_SERVER.getHandshakeState((ServerPlayer)player).state == HandshakeServer.HandshakeState.ACCEPTED).forEach(player -> ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)payload));
    }
}

