/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.mixin.client.roll;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.RollMouse;
import nl.enjarai.doabarrelroll.config.ModConfig;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public abstract class MouseMixin
implements RollMouse {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private final Vector2d mouseTurnVec = new Vector2d();

    @Inject(method={"handleAccumulatedMovement()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;isMouseGrabbed()Z", ordinal=0)})
    private void doABarrelRoll$maintainMouseMomentum(CallbackInfo ci, @Local(ordinal=1) double e) {
        if (this.minecraft.player != null && !this.minecraft.isPaused()) {
            this.doABarrelRoll$updateMouse(this.minecraft.player, 0.0, 0.0, e);
        }
    }

    @WrapWithCondition(method={"turnPlayer(D)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;turn(DD)V")})
    private boolean doABarrelRoll$changeLookDirection(LocalPlayer player, double cursorDeltaX, double cursorDeltaY, @Local(argsOnly=true) double timeDelta) {
        return !this.doABarrelRoll$updateMouse(player, cursorDeltaX, cursorDeltaY, timeDelta);
    }

    @Override
    public boolean doABarrelRoll$updateMouse(LocalPlayer player, double cursorDeltaX, double cursorDeltaY, double mouseDelta) {
        RollEntity rollPlayer = (RollEntity)player;
        if (rollPlayer.doABarrelRoll$isRolling()) {
            if (ModConfig.INSTANCE.getMomentumBasedMouse()) {
                this.mouseTurnVec.add((Vector2dc)new Vector2d(cursorDeltaX, cursorDeltaY).mul(0.0033333334140479565));
                if (this.mouseTurnVec.lengthSquared() > 1.0) {
                    this.mouseTurnVec.normalize();
                }
                Vector2d readyTurnVec = new Vector2d((Vector2dc)this.mouseTurnVec);
                double deadzone = ModConfig.INSTANCE.getMomentumMouseDeadzone();
                if (readyTurnVec.lengthSquared() < deadzone * deadzone) {
                    readyTurnVec.zero();
                }
                readyTurnVec.mul((double)(1200.0f * (float)mouseDelta));
                rollPlayer.doABarrelRoll$changeElytraLook(readyTurnVec.y, readyTurnVec.x, 0.0, ModConfig.INSTANCE.getDesktopSensitivity(), mouseDelta);
            } else {
                this.mouseTurnVec.zero();
                rollPlayer.doABarrelRoll$changeElytraLook(cursorDeltaY, cursorDeltaX, 0.0, ModConfig.INSTANCE.getDesktopSensitivity(), mouseDelta);
            }
            return true;
        }
        this.mouseTurnVec.zero();
        return false;
    }

    @Override
    public Vector2d doABarrelRoll$getMouseTurnVec() {
        return this.mouseTurnVec;
    }
}

