/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.mixin.client.roll;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import nl.enjarai.doabarrelroll.api.RollCamera;
import nl.enjarai.doabarrelroll.api.RollEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin
implements RollCamera {
    @Shadow
    private Entity entity;
    @Unique
    private boolean isRolling;
    @Unique
    private float lastRollBack;
    @Unique
    private float rollBack;
    @Shadow
    private float roll;

    @Inject(method={"tick()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Camera;eyeHeight:F", ordinal=0)})
    private void doABarrelRoll$interpolateRollnt(CallbackInfo ci) {
        if (!((RollEntity)this.entity).doABarrelRoll$isRolling()) {
            this.lastRollBack = this.rollBack;
            this.rollBack -= this.rollBack * 0.5f;
        }
    }

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="HEAD")})
    private void doABarrelRoll$captureTickDeltaAndUpdate(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci, @Share(value="tickDelta") LocalFloatRef tickDeltaRef) {
        tickDeltaRef.set(tickDelta);
        this.isRolling = ((RollEntity)focusedEntity).doABarrelRoll$isRolling();
    }

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="TAIL")})
    private void doABarrelRoll$updateRollBack(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        if (this.isRolling) {
            this.rollBack = this.roll;
            this.lastRollBack = this.roll;
        }
    }

    @ModifyArg(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FFF)V", ordinal=0), index=2)
    private float doABarrelRoll$addRoll2(float original, @Share(value="tickDelta") LocalFloatRef tickDelta) {
        if (this.isRolling) {
            return original + ((RollEntity)this.entity).doABarrelRoll$getRoll(tickDelta.get());
        }
        return original + Mth.lerp((float)tickDelta.get(), (float)this.lastRollBack, (float)this.rollBack);
    }

    @ModifyArg(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FFF)V", ordinal=1), index=2)
    private float doABarrelRoll$addRoll3(float original, @Share(value="tickDelta") LocalFloatRef tickDelta) {
        if (this.isRolling) {
            return original - ((RollEntity)this.entity).doABarrelRoll$getRoll(tickDelta.get());
        }
        return original - Mth.lerp((float)tickDelta.get(), (float)this.lastRollBack, (float)this.rollBack);
    }

    @Override
    public float doABarrelRoll$getRoll() {
        return this.roll;
    }
}

