/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.mixin.client;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.doabarrelroll.ModKeybindings;
import nl.enjarai.doabarrelroll.api.event.ThrustEvents;
import nl.enjarai.doabarrelroll.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={LivingEntity.class}, priority=1200)
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyArg(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=6))
    private Vec3 doABarrelRoll$wrapElytraVelocity(Vec3 original) {
        if (!(this instanceof LocalPlayer) || !ModConfig.INSTANCE.getEnableThrust()) {
            return original;
        }
        Vec3 rotation = this.getLookAngle();
        Vec3 velocity = this.getDeltaMovement();
        double throttleSign = ModKeybindings.THRUST_FORWARD.isDown() ? 1.0 : (ModKeybindings.THRUST_BACKWARD.isDown() ? -1.0 : 0.0);
        throttleSign = ThrustEvents.modifyThrustInput(throttleSign);
        if (ModConfig.INSTANCE.getThrustParticles()) {
            int particleDensity = (int)Mth.clamp((double)(throttleSign * 10.0), (double)0.0, (double)10.0);
            if (throttleSign > 0.1 && this.level().getGameTime() % (long)(11 - particleDensity) == 0L) {
                Vec3 pPos = this.position().add(velocity.scale(0.5).reverse());
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, pPos.x(), pPos.y(), pPos.z(), 0.0, 0.0, 0.0);
            }
        }
        double maxSpeed = ModConfig.INSTANCE.getMaxThrust();
        double speedIncrease = Math.max(maxSpeed - velocity.length(), 0.0) / maxSpeed * throttleSign;
        double acceleration = ModConfig.INSTANCE.getThrustAcceleration() * speedIncrease;
        return original.add(rotation.x * acceleration, rotation.y * acceleration, rotation.z * acceleration);
    }
}

