/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.math;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import nl.enjarai.doabarrelroll.math.SyntaxHighlightContext;
import nl.enjarai.doabarrelroll.math.SyntaxType;

public class SyntaxHighlighter {
    private static final boolean debugLog = false;

    public static Component highlightText(String text) {
        MutableComponent formattedText = Component.literal((String)"");
        SyntaxHighlightContext context = new SyntaxHighlightContext(text);
        while (context.getCurrent() != '\u0000') {
            if (context.getCurrent() == '$') {
                formattedText.append(String.valueOf(context.getCurrent()));
                ++context.position;
                while (SyntaxHighlighter.isLetter(context.getCurrent()) || context.getCurrent() == '_') {
                    formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Variable));
                    ++context.position;
                }
                continue;
            }
            if (context.getCurrent() == '-' || context.getCurrent() == '+') {
                if (Character.isDigit(context.peek()) && context.lastIsNotValue()) {
                    formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Number));
                    ++context.position;
                    continue;
                }
                if (SyntaxHighlighter.isLetter(context.peek()) && context.lastIsNotValue()) {
                    formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Function));
                    ++context.position;
                    continue;
                }
                formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Operator));
                ++context.position;
                continue;
            }
            if (Character.isDigit(context.getCurrent()) || context.getCurrent() == '.') {
                formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Number));
                ++context.position;
                continue;
            }
            if (SyntaxHighlighter.isLetter(context.getCurrent())) {
                StringBuilder builder = new StringBuilder();
                while (SyntaxHighlighter.isLetter(context.getCurrent()) || context.getCurrent() == '_') {
                    builder.append(context.getCurrent());
                    ++context.position;
                }
                String builtResult = builder.toString();
                if (SyntaxHighlighter.isKeyword(builtResult) && context.getCurrent() == '(') {
                    formattedText.append((Component)SyntaxHighlighter.formatText(builtResult, SyntaxType.Function));
                    continue;
                }
                if (SyntaxHighlighter.isConstant(builtResult)) {
                    formattedText.append((Component)SyntaxHighlighter.formatText(builtResult, SyntaxType.Constant));
                    continue;
                }
                formattedText.append((Component)SyntaxHighlighter.formatText(builtResult, SyntaxType.Error));
                continue;
            }
            if (SyntaxHighlighter.isOperator(context.getCurrent())) {
                formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Operator));
                ++context.position;
                continue;
            }
            if (SyntaxHighlighter.isScope(context.getCurrent())) {
                formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Scope));
                ++context.position;
                continue;
            }
            if (Character.isWhitespace(context.getCurrent())) {
                formattedText.append(String.valueOf(context.getCurrent()));
                ++context.position;
                continue;
            }
            formattedText.append((Component)SyntaxHighlighter.formatText(context.getCurrent(), SyntaxType.Error));
            ++context.position;
        }
        return formattedText;
    }

    public static boolean isConstant(String str) {
        switch (str) {
            case "PI": 
            case "E": 
            case "TO_RAD": 
            case "TO_DEG": {
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyword(String str) {
        switch (str) {
            case "sqrt": 
            case "sin": 
            case "cos": 
            case "tan": 
            case "asin": 
            case "acos": 
            case "atan": 
            case "abs": 
            case "exp": 
            case "ceil": 
            case "floor": 
            case "log": 
            case "round": 
            case "randint": 
            case "min": 
            case "max": {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '^';
    }

    public static boolean isScope(char c) {
        return c == ',' || c == '(' || c == ')';
    }

    public static MutableComponent formatText(char ch, SyntaxType type) {
        String str = String.valueOf(ch);
        return SyntaxHighlighter.formatText(str, type);
    }

    public static MutableComponent formatText(String str, SyntaxType type) {
        switch (type) {
            case Variable: {
                return Component.literal((String)str).withStyle(ChatFormatting.GREEN);
            }
            case Operator: {
                return Component.literal((String)str).withStyle(ChatFormatting.LIGHT_PURPLE);
            }
            case Error: {
                return Component.literal((String)str).withStyle(ChatFormatting.RED);
            }
            case Number: {
                return Component.literal((String)str).withStyle(ChatFormatting.AQUA);
            }
            case Function: {
                return Component.literal((String)str).withStyle(ChatFormatting.YELLOW);
            }
            case Constant: {
                return Component.literal((String)str).setStyle(Style.EMPTY.withColor(16753920));
            }
            case Scope: {
                return Component.literal((String)str);
            }
        }
        return null;
    }
}

