/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedStairsGeometry
extends Geometry {
    private final Direction facing;
    private final Direction rotDir;
    private final Direction rotDirTwo;
    private final boolean ySlope;

    public FramedVerticalSlopedStairsGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.rotDir = rot.withFacing(this.facing);
        this.rotDirTwo = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(this.facing);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction slopeRotDir;
        Direction quadDir = quad.getDirection();
        if (quadDir == this.rotDir || quadDir == this.rotDirTwo) {
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.facing.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(this.rotDir, 1.0f, 0.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSide(this.rotDir.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        boolean useRotDirQuad = Utils.isY(this.rotDir) == this.ySlope;
        Direction slopeQuadDir = useRotDirQuad ? this.rotDir : this.rotDirTwo;
        Direction direction = slopeRotDir = useRotDirQuad ? this.rotDirTwo : this.rotDir;
        if (quadDir == slopeQuadDir) {
            if (Utils.isY(slopeQuadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(slopeRotDir, 45.0f)).export(quadMap.get(null));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(slopeRotDir == Direction.UP, 45.0f)).export(quadMap.get(null));
            }
        }
    }
}

