/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContent;

public abstract class CamoContainer<C extends CamoContent<C>, T extends CamoContainer<C, T>> {
    protected final C content;

    protected CamoContainer(C content) {
        this.content = content;
    }

    public final C getContent() {
        return this.content;
    }

    @Nullable
    public MapColor getMapColor(BlockGetter level, BlockPos pos) {
        return ((CamoContent)this.content).getMapColor(level, pos);
    }

    public int getTintColor(BlockAndTintGetter level, BlockPos pos, int tintIdx) {
        return ((CamoContent)this.content).getTintColor(level, pos, tintIdx);
    }

    public int getTintColor(ItemStack stack, int tintIdx) {
        return ((CamoContent)this.content).getTintColor(stack, tintIdx);
    }

    @Nullable
    public Integer getBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return ((CamoContent)this.content).getBeaconColorMultiplier(level, pos, beaconPos);
    }

    public abstract boolean canRotateCamo();

    @Nullable
    public abstract T rotateCamo();

    public final boolean canTriviallyConvertToItemStack() {
        return this.getFactory().canTriviallyConvertToItemStack();
    }

    public final boolean isEmpty() {
        return ((CamoContent)this.content).isEmpty();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract CamoContainerFactory<T> getFactory();
}

