/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.network.handler;

import com.mrbysco.disccord.config.DiscCordConfig;
import com.mrbysco.disccord.network.payload.SetRecordUrlPayload;
import com.mrbysco.disccord.registry.ModDataComponents;
import com.mrbysco.disccord.registry.ModRegistry;
import java.net.URL;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleRecordUrl(SetRecordUrlPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                Player player = context.player();
                ItemStack currentItem = player.getItemInHand(player.getUsedItemHand());
                if (!currentItem.is((Item)ModRegistry.CUSTOM_RECORD.get())) {
                    return;
                }
                try {
                    new URL(data.url()).toURI();
                }
                catch (Exception e) {
                    player.sendSystemMessage((Component)Component.translatable((String)"disccord.song_url.invalid"));
                    return;
                }
                if (data.url().length() >= 400) {
                    player.sendSystemMessage((Component)Component.translatable((String)"disccord.song_url.long"));
                    return;
                }
                for (String url : (List)DiscCordConfig.SERVER.whitelistedUrls.get()) {
                    if (!data.url().startsWith(url)) continue;
                    player.playNotifySound(SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
                    currentItem.set(ModDataComponents.MUSIC_URL.get(), (Object)data.url());
                    return;
                }
                player.sendSystemMessage((Component)Component.translatable((String)"disccord.song_url.websites").append(",").append(((List)DiscCordConfig.SERVER.whitelistedWebsites.get()).toString()));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"disccord.networking.set_record_url.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

