/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.network.handler;

import com.mrbysco.disccord.client.ClientHandler;
import com.mrbysco.disccord.client.screen.MusicDiscScreen;
import com.mrbysco.disccord.network.payload.OpenMusicDiscScreenPayload;
import com.mrbysco.disccord.network.payload.PlayRecordPayload;
import com.mrbysco.disccord.registry.ModDataComponents;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleDiscScreen(OpenMusicDiscScreenPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (FMLEnvironment.dist.isClient()) {
                ItemStack disc = data.disc();
                String currentUrl = (String)disc.getOrDefault(ModDataComponents.MUSIC_URL, (Object)"URL");
                MusicDiscScreen.openScreen((Component)Component.literal((String)"DiscCord"), currentUrl);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"disccord.networking.open_disc_screen.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleRecordPlay(PlayRecordPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (FMLEnvironment.dist.isClient()) {
                Vec3 centerPos = data.pos().getCenter();
                String fileUrl = data.url();
                UUID uuid = data.uuid();
                ClientHandler.playRecord(centerPos, fileUrl, uuid);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"disccord.networking.play_record.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

