/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.item;

import com.mrbysco.disccord.network.payload.OpenMusicDiscScreenPayload;
import com.mrbysco.disccord.registry.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DiscCordItem
extends Item {
    public DiscCordItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((CustomPacketPayload)new OpenMusicDiscScreenPayload(stackInHand));
        }
        return InteractionResultHolder.success((Object)stackInHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String currentURL = (String)stack.getOrDefault(ModDataComponents.MUSIC_URL, (Object)"");
        if (!currentURL.isEmpty() && tooltipFlag.isAdvanced()) {
            MutableComponent urlComponent = Component.literal((String)currentURL).withStyle(ChatFormatting.BLUE);
            tooltipComponents.add((Component)Component.translatable((String)"item.disccord.custom_record.tooltip", (Object[])new Object[]{urlComponent}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

