/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.compat.mixin;

import com.mrbysco.disccord.network.payload.PlayRecordPayload;
import com.mrbysco.disccord.registry.ModDataComponents;
import com.mrbysco.disccord.registry.ModRegistry;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JukeboxUpgradeWrapper.class})
public abstract class JukeboxUpgradeItemMixin
extends UpgradeWrapperBase<JukeboxUpgradeWrapper, JukeboxUpgradeItem> {
    @Shadow
    @Final
    private LinkedList<Integer> playlist;
    @Shadow
    @Final
    private LinkedList<Integer> history;
    @Shadow
    @Nullable
    private Entity entityPlaying;
    @Shadow
    @Nullable
    private BlockPos posPlaying;
    @Shadow
    @Nullable
    private Level levelPlaying;

    protected JukeboxUpgradeItemMixin(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
    }

    @Shadow
    protected abstract void setIsPlaying(boolean var1);

    @Shadow
    public abstract ItemStack getDisc();

    @Shadow
    protected abstract void setDiscSlotActive(int var1);

    @Shadow
    public abstract Optional<Holder<JukeboxSong>> getJukeboxSongHolder(Level var1);

    @Inject(at={@At(value="HEAD")}, method={"stop(Lnet/minecraft/world/entity/LivingEntity;)V"})
    public void disccord$stop(LivingEntity entity, CallbackInfo ci) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> {
                PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, (ServerPlayer)null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)128.0, (CustomPacketPayload)new PlayRecordPayload(entity.blockPosition(), "", (UUID)storageUuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.setIsPlaying(false);
            });
            this.setIsPlaying(false);
            this.upgrade.remove(ModCoreDataComponents.DISC_FINISH_TIME);
            this.setDiscSlotActive(-1);
            this.playlist.clear();
            this.history.clear();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playDisc()V"}, remap=false)
    public void disccord$playDisc(CallbackInfo ci) {
        if (this.getDisc().is((Item)ModRegistry.CUSTOM_RECORD.get())) {
            Level level;
            Level level2 = level = this.entityPlaying != null ? this.entityPlaying.level() : this.levelPlaying;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.posPlaying != null || this.entityPlaying != null) {
                    if (this.getDisc().isEmpty()) {
                        return;
                    }
                    this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> this.getJukeboxSongHolder(level).ifPresent(song -> {
                        String musicUrl = (String)this.getDisc().getOrDefault(ModDataComponents.MUSIC_URL.get(), (Object)"");
                        if (this.entityPlaying != null) {
                            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, (ServerPlayer)null, (double)this.entityPlaying.getX(), (double)this.entityPlaying.getY(), (double)this.entityPlaying.getZ(), (double)128.0, (CustomPacketPayload)new PlayRecordPayload(this.entityPlaying.blockPosition(), musicUrl, (UUID)storageUuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, (ServerPlayer)null, (double)this.posPlaying.getX(), (double)this.posPlaying.getY(), (double)this.posPlaying.getZ(), (double)128.0, (CustomPacketPayload)new PlayRecordPayload(this.posPlaying, musicUrl, (UUID)storageUuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        this.upgrade.set(ModCoreDataComponents.DISC_FINISH_TIME, (Object)(level.getGameTime() + (long)((JukeboxSong)song.value()).lengthInTicks()));
                    }));
                    this.setIsPlaying(true);
                    return;
                }
            }
            ci.cancel();
        }
    }
}

