/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client.screen;

import com.mrbysco.disccord.DiscCordMod;
import com.mrbysco.disccord.network.payload.SetRecordUrlPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class MusicDiscScreen
extends Screen {
    private static final ResourceLocation TEXTURE = DiscCordMod.modLoc("textures/gui/record_input.png");
    private static final ResourceLocation TEXT_FIELD_TEXTURE = ResourceLocation.withDefaultNamespace((String)"container/anvil/text_field");
    private EditBox nameField;
    private final int backgroundWidth = 176;
    private final int backgroundHeight = 44;
    private final String inputDefaultText;

    public MusicDiscScreen(Component title, String inputDefaultText) {
        super(title);
        this.inputDefaultText = inputDefaultText;
    }

    public static void openScreen(Component title, String inputDefaultText) {
        Minecraft.getInstance().setScreen((Screen)new MusicDiscScreen(title, inputDefaultText));
    }

    public void updateTextPosition() {
        if (this.font == null) {
            return;
        }
        int x = (this.width - 176) / 2;
        int y = (this.height - 44) / 2;
        this.nameField = new EditBox(this.font, x + 62, y + 18, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.nameField.setCanLoseFocus(false);
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(200);
        this.nameField.setResponder(this::onRenamed);
        this.nameField.setValue(this.inputDefaultText);
        this.addWidget((GuiEventListener)this.nameField);
        this.setInitialFocus((GuiEventListener)this.nameField);
        this.nameField.setEditable(true);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        String string = this.nameField.getValue();
        this.updateTextPosition();
        this.nameField.setValue(string);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257) {
            if (!this.nameField.getValue().equals(this.inputDefaultText)) {
                this.minecraft.getConnection().send((CustomPacketPayload)new SetRecordUrlPayload(this.nameField.getValue()));
            }
            this.minecraft.player.closeContainer();
        }
        if (this.nameField.keyPressed(keyCode, scanCode, modifiers) || this.nameField.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void onRenamed(String s) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - 176) / 2;
        int y = (this.height - 44) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, 176, 44);
        graphics.blitSprite(TEXT_FIELD_TEXTURE, x + 59, y + 14, 110, 16);
        if (this.nameField == null) {
            this.updateTextPosition();
        }
        this.nameField.render(graphics, mouseX, mouseY, partialTick);
    }
}

