/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client.audio;

import com.mrbysco.disccord.DiscCordMod;
import com.mrbysco.disccord.client.audio.FFmpeg;
import com.mrbysco.disccord.client.audio.YoutubeDL;
import com.mrbysco.disccord.util.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;

public class AudioHandlerClient {
    public boolean checkForAudioFile(String urlName) {
        String hashedName = Hashing.Sha256(this.getMinecraftified(urlName));
        File audio = new File(FMLPaths.CONFIGDIR.get().resolve("disccord/client_downloads/" + hashedName + ".ogg").toString());
        return audio.exists();
    }

    public CompletableFuture<Boolean> downloadVideoAsOgg(String urlName) {
        return CompletableFuture.supplyAsync(() -> {
            String inPath;
            Minecraft mc = Minecraft.getInstance();
            String hashedName = Hashing.Sha256(this.getMinecraftified(urlName));
            String audioIn = FMLPaths.CONFIGDIR.get().resolve("disccord/client_downloads/" + hashedName).toString();
            File audioOut = new File(FMLPaths.CONFIGDIR.get().resolve("disccord/client_downloads/" + hashedName + ".ogg").toString());
            try {
                inPath = YoutubeDL.executeYoutubeDLCommand("-S", "res:144", "-o", audioIn, urlName, "--print", "after_move:filepath");
            }
            catch (IOException | InterruptedException e) {
                mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.song.downloading_failed").withStyle(ChatFormatting.RED));
                DiscCordMod.LOGGER.error("Failed to download music", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                FFmpeg.executeFFmpegCommand("-i", inPath, "-c:a", "libvorbis", "-ac", "1", "-b:a", "64k", "-vn", "-y", "-nostdin", "-nostats", "-loglevel", "0", audioOut.getAbsolutePath());
            }
            catch (IOException | InterruptedException e) {
                mc.player.sendSystemMessage((Component)Component.translatable((String)"disccord.song.transcoding_failed").withStyle(ChatFormatting.RED));
                DiscCordMod.LOGGER.error("Failed to transcode music", (Throwable)e);
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    public InputStream getAudioInputStream(String urlName) {
        FileInputStream fileStream;
        String hashedName = Hashing.Sha256(this.getMinecraftified(urlName));
        DiscCordMod.LOGGER.debug("Getting audio stream for {} with SHA256 {}", (Object)urlName, (Object)hashedName);
        File audio = new File(FMLPaths.CONFIGDIR.get().resolve("disccord/client_downloads/" + hashedName + ".ogg").toString());
        try {
            fileStream = new FileInputStream(audio);
        }
        catch (FileNotFoundException e) {
            DiscCordMod.LOGGER.error("Failed to load audio stream", (Throwable)e);
            return null;
        }
        return fileStream;
    }

    private String getMinecraftified(String url) {
        return url.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9/._-]", "_");
    }
}

