/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import java.util.List;
import java.util.Optional;
import me.chrr.camerapture.Camerapture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class AlbumCloningRecipe
extends CustomRecipe {
    public AlbumCloningRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level world) {
        return this.getRecipe(input.items()).isPresent();
    }

    public ItemStack craft(CraftingInput input, HolderLookup.Provider lookup) {
        return this.getRecipe(input.items()).map(Tuple::getA).orElse(null);
    }

    public NonNullList<ItemStack> getRemainder(CraftingInput input) {
        return this.getRecipe(input.items()).map(Tuple::getB).orElse(null);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    private Optional<Tuple<ItemStack, NonNullList<ItemStack>>> getRecipe(List<ItemStack> items) {
        NonNullList remainder = NonNullList.withSize((int)items.size(), (Object)ItemStack.EMPTY);
        ItemStack album = ItemStack.EMPTY;
        boolean book = false;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (stack.isEmpty()) continue;
            if (stack.is(Camerapture.ALBUM)) {
                if (!album.isEmpty()) {
                    return Optional.empty();
                }
                remainder.set(i, (Object)stack.copyWithCount(1));
                album = stack;
                continue;
            }
            if (!stack.is(Items.WRITABLE_BOOK) || book) {
                return Optional.empty();
            }
            book = true;
        }
        if (album.isEmpty() || !book) {
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)album.copy(), (Object)remainder));
    }

    public RecipeSerializer<AlbumCloningRecipe> getSerializer() {
        return Camerapture.ALBUM_CLONING;
    }
}

