/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.picture.PictureTaker;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class UploadScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/upload_picture.png");
    private static final int backgroundWidth = 256;
    private static final int backgroundHeight = 128;
    private PlainTextButton browseButton;

    public UploadScreen() {
        super((Component)Component.translatable((String)"text.camerapture.upload_picture.title").withStyle(ChatFormatting.BOLD));
    }

    protected void init() {
        super.init();
        MutableComponent text = Component.translatable((String)"text.camerapture.upload_picture.browse").withStyle(ChatFormatting.UNDERLINE);
        int w = this.font.width((FormattedText)text);
        int n = this.width / 2 - w / 2;
        int n2 = this.height / 2;
        Objects.requireNonNull(this.font);
        int n3 = n2 + 9 + 4;
        Objects.requireNonNull(this.font);
        this.browseButton = (PlainTextButton)this.addRenderableWidget((GuiEventListener)new PlainTextButton(n, n3, w, 9, (Component)text, button -> this.browseFile(), this.font));
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean canTakePicture;
        super.render(context, mouseX, mouseY, delta);
        MutableComponent description = Component.translatable((String)"text.camerapture.upload_picture.description");
        context.blit(TEXTURE, this.width / 2 - 128, this.height / 2 - 64, 0.0f, 0.0f, 256, 128, 256, 256);
        int n = this.width / 2;
        int n2 = this.height / 2;
        Objects.requireNonNull(this.font);
        context.drawCenteredString(this.font, this.title, n, n2 - 9 - 16, 0xFFFFFF);
        this.browseButton.visible = canTakePicture = this.minecraft != null && this.minecraft.player != null && CameraItem.canTakePicture((Player)this.minecraft.player);
        if (!canTakePicture) {
            if (System.currentTimeMillis() % 1000L < 500L) {
                int n3 = this.height / 2;
                Objects.requireNonNull(this.font);
                int y = n3 + 9 + 4;
                context.drawCenteredString(this.font, (Component)Component.translatable((String)"text.camerapture.no_paper"), this.width / 2, y, -65536);
            }
        } else {
            context.drawCenteredString(this.font, (Component)description, this.width / 2, this.height / 2, 0xFFFFFF);
        }
    }

    public void onFilesDrop(List<Path> paths) {
        for (Path path : paths) {
            if (!this.tryUpload(path)) continue;
            this.onClose();
            return;
        }
    }

    private void browseFile() {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"*"));
                filter.flip();
                String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Open Image", (CharSequence)"", (PointerBuffer)filter, (CharSequence)"Image File", (boolean)false);
                if (path == null) {
                    return;
                }
                try {
                    if (this.tryUpload(Path.of(path, new String[0]))) {
                        Minecraft.getInstance().executeIfPossible(() -> ((UploadScreen)this).onClose());
                    }
                }
                catch (InvalidPathException e) {
                    Camerapture.LOGGER.error("tinyfd returned invalid path", (Throwable)e);
                }
            }
        }).start();
    }

    private boolean tryUpload(Path path) {
        boolean canTakePicture;
        boolean bl = canTakePicture = this.minecraft != null && this.minecraft.player != null && CameraItem.canTakePicture((Player)this.minecraft.player);
        if (!canTakePicture) {
            return false;
        }
        PictureTaker.getInstance().tryUploadFile(path);
        return true;
    }
}

